//=============================================================================
// Pop them friggin balloons
// Heads up display
//=============================================================================
class PBHUD extends ChallengeHUD config(User);

var string MapList[512];

//Weapon variables:
var texture 		PBWeapon[20];
var string			WeaponString1[20],
					WeaponString2[20],
					WeaponString3[20],
					PriLayersPopped[20],
					AltLayersPopped[20],
					DescriptionString1[20],
					DescriptionString2[20];
var int				WeaponPrice[20],
					UnlockRank[20];
//Tower variables:
var string			TowerName[20],
					TowerString1[20],
					TowerString2[20];
var int				TowerPrice[20];
					
var config string 	Key;
var color 			FadeColor;
var int				FadeColorValue,
					GameOverDelay;
var bool			bFadeDown,
					bGameOver,
					bGameOverSndPlayed,
					bDrawGameOverText,
					bDrawVictory, bPlayVictory;
var int				VictoryDrawTime;

//Music vars:
var Music			Songs[200];
var String			Titles[200];
var int				SelectedSong;

#exec OBJ LOAD FILE=..\Textures\LadrStatic.utx PACKAGE=Botpack.LadrStatic
#exec OBJ LOAD FILE=..\Sounds\Announcer.uax

var() int SizeY,Count;
var string CurrentMessage;
var float MOTDFadeOutTime;

var float IdentifyFadeTime;
var PlayerReplicationInfo IdentifyTarget;
var Pawn PawnOwner;	// pawn currently managing this HUD (may be the viewtarget of the owner rather than the owner)
var FontInfo MyFonts;

// Localized Messages
var HUDLocalizedMessage ShortMessageQueue[4];
var HUDLocalizedMessage LocalMessages[10];

var texture FaceTexture;
var float FaceTime;
var color FaceTeam;
 
var() localized string VersionMessage, PlayerCountString;
var localized string MapTitleString, AuthorString;
var localized string MapTitleString2, AuthorString2;

var localized string RankString;
var localized string SpreadString;

var int PlayerCount;
var bool bTiedScore;

var string ReceivedMessage;
var string ReceivedName;
var ZoneInfo ReceivedZone;
var float ReceivedTime;
var texture TutIconTex;
var int TutIconX, TutIconY;
var float TutIconBlink;

var texture CrossHairTextures[20];

var texture GrayWeapons[11];
var texture FP1[3], FP2[3], FP3[3];
var int LastReportedTime;
var bool bStartUpMessage, bForceScores;
var bool bTimeValid;
var bool bLowRes;
var bool bResChanged;
var int OldClipX;

// configuration options
var bool bAlwaysHideFrags, bHideCenterMessages;
var float Scale;
var byte Style;
var color BaseColor, WhiteColor, RedColor, GreenColor, CyanColor, UnitColor, BlueColor,
		 GoldColor, HUDColor, SolidHUDColor, PurpleColor, TurqColor, GrayColor, FaceColor;

// Identify Strings
var localized string IdentifyName, IdentifyHealth, IdentifyCallsign;
var localized string LiveFeed;

// scoring 
var float ScoreTime;
var int rank, lead;

// showing damage
var vector HitPos[4];
var float HitTime[4];
var float HitDamage[4];

var float PickupTime;

var float WeaponNameFade;
var float MessageFadeTime;
var int MessageFadeCount;
var bool bDrawMessageArea;
var bool bDrawFaceArea;
var float FaceAreaOffset, MinFaceAreaOffset;
var class<CriticalEventPlus> TimeMessageClass;

// Server info.
var ServerInfo ServerInfo;
var bool bShowInfo;

var class<ServerInfo> ServerInfoClass;

var vector FixedLocation;
var bool bFixedLocation;
var bool bLeftKeyPressed, bRightKeyPressed, bUpKeyPressed, bDownKeyPressed, bNoUpgradesAvailable;
var int ShowWeapon, ShowTower, ShowUpgrade;
var string MenuKeyName;

function PreBeginPlay()
{
	Super.PreBeginPlay();
	
	LoadMaps();
}

/* Load all PB maps into map array */
function LoadMaps()
{
local string FirstMap,NextMap,MapName,TestMap;
local int i,length,MapCount;

	FirstMap = Level.GetMapName("PB", "", 0);
	NextMap = FirstMap;
	while(!(FirstMap ~= TestMap))
		{
		MapName = NextMap;
		length = InStr(Caps(MapName), ".UNR");
		if(length != -1)
			{
			MapName = Left(MapName, length);  // remove ".unr"
			length = Len(MapName);
			MapName = Right(MapName, length - 3); // remove "PB-"
			MapList[MapCount] = MapName;
			MapCount++;
			}
		NextMap = Level.GetMapName("PB", NextMap, 1);
		TestMap = NextMap;
		if(MapCount > 512)
			break;
		}
}

function CycleFadeColor()
{
	if ( bFadeDown )
		{
		FadeColorValue -= 5;
		if ( FadeColorValue < 0 )
			{
			bFadeDown = False;
			FadeColorValue = 0;
			}
		}
	else
		{
		FadeColorValue += 5;
		if ( FadeColorValue > 255 )
			{
			bFadeDown = True;
			FadeColorValue = 255;
			}
		}
	FadeColor.R = FadeColorValue;
	FadeColor.G = FadeColorValue;
	FadeColor.B = FadeColorValue;
}

//Track if player navigate in the menu (notice left and right are switched somehow??))
simulated function TrackInput(Canvas Canvas)
{
	//Player pressed UP arrow:
	if ( PlayerPawn(Owner).bWasForward && !bUpKeyPressed )
		{
		//Weapon check:
		if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawWeaponsMenu && ShowWeapon != 10 )
			{
			if ( ShowWeapon < 10 )
				ShowWeapon += 1;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		//Tower check:
		else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawTowerMenu && ShowTower != 5 )
			{
			if ( ShowTower < 5 )
				ShowTower += 1;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		//Upgrade check:
		else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawUpgradeMenu && ShowUpgrade < 6 )
			{
			if ( ShowUpgrade == 5 )
				{
				if ( !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasCamoDetection )
					ShowUpgrade = 6;
				}
			else if ( ShowUpgrade == 4 )
				{
				if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasRingOfFire && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).RingOfFireLevel < 3 )
					ShowUpgrade = 5;
				else if ( !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasCamoDetection )
					ShowUpgrade = 6;
				}
			else if ( ShowUpgrade == 3 )
				{
				if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasNali && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).NaliLevel < 3 )
					ShowUpgrade = 4;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasRingOfFire && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).RingOfFireLevel < 3 )
					ShowUpgrade = 5;
				else if ( !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasCamoDetection )
					ShowUpgrade = 6;
				}
			else if ( ShowUpgrade == 2 )
				{
				if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasWarlord && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).WarlordLevel < 3 )
					ShowUpgrade = 3;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasNali && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).NaliLevel < 3 )
					ShowUpgrade = 4;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasRingOfFire && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).RingOfFireLevel < 3 )
					ShowUpgrade = 5;
				else if ( !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasCamoDetection )
					ShowUpgrade = 6;
				}
			else if ( ShowUpgrade == 1 )
				{
				if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasLaserCannon && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).LaserCannonLevel < 3 )
					ShowUpgrade = 2;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasWarlord && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).WarlordLevel < 3 )
					ShowUpgrade = 3;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasNali && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).NaliLevel < 3 )
					ShowUpgrade = 4;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasRingOfFire && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).RingOfFireLevel < 3 )
					ShowUpgrade = 5;
				else if ( !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasCamoDetection )
					ShowUpgrade = 6;
				}
			else if ( ShowUpgrade == 0 )
				{
				if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasSlithTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SlithLevel < 3 )
					ShowUpgrade = 1;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasLaserCannon && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).LaserCannonLevel < 3 )
					ShowUpgrade = 2;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasWarlord && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).WarlordLevel < 3 )
					ShowUpgrade = 3;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasNali && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).NaliLevel < 3 )
					ShowUpgrade = 4;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasRingOfFire && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).RingOfFireLevel < 3 )
					ShowUpgrade = 5;
				else if ( !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasCamoDetection )
					ShowUpgrade = 6;
				}
			else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasKrallTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).KrallLevel < 3 )
				ShowUpgrade = 0;
			else
				ShowUpgrade = 999;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		//Music check:
		else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawMusicMenu )
			{
			if ( SelectedSong > 0 && Titles[SelectedSong - 1] != "")
				{
				SelectedSong -= 1;
				PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong = SelectedSong;
				PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
				}
			}
		//Vote menu check:
		if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawVoteMenu && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum > 0)
			{
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum -= 1;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		bUpKeyPressed = True;
		}
	else if ( !PlayerPawn(Owner).bWasForward )
		bUpKeyPressed = False;
	
	//Player pressed DOWN arrow:
	if ( PlayerPawn(Owner).bWasBack && !bDownKeyPressed )
		{
		//Weapon check:
		if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawWeaponsMenu && ShowWeapon != 0 )
			{
			if ( ShowWeapon > 0 )
				ShowWeapon -= 1;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		//Tower check:
		else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawTowerMenu && ShowTower != 0 )
			{
			if ( ShowTower > 0 )
				ShowTower -= 1;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		//Upgrade check:
		else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawUpgradeMenu && ShowUpgrade > 0 )
			{
			if ( ShowUpgrade == 1 && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasKrallTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).KrallLevel < 3)
				ShowUpgrade = 0;
			else if ( ShowUpgrade == 2 )
				{
				if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasSlithTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SlithLevel < 3 )
					ShowUpgrade = 1;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasKrallTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).KrallLevel < 3 )
					ShowUpgrade = 0;
				}
			else if ( ShowUpgrade == 3 )
				{
				if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasLaserCannon && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).LaserCannonLevel < 3 )
					ShowUpgrade = 2;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasSlithTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SlithLevel < 3 )
					ShowUpgrade = 1;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasKrallTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).KrallLevel < 3 )
					ShowUpgrade = 0;
				}
			else if ( ShowUpgrade == 4 )
				{
				if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasWarlord && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).WarlordLevel < 3 )
					ShowUpgrade = 3;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasLaserCannon && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).LaserCannonLevel < 3 )
					ShowUpgrade = 2;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasSlithTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SlithLevel < 3 )
					ShowUpgrade = 1;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasKrallTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).KrallLevel < 3 )
					ShowUpgrade = 0;
				}
			else if ( ShowUpgrade == 5 )
				{
				if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasNali && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).NaliLevel < 3 )
					ShowUpgrade = 4;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasWarlord && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).WarlordLevel < 3 )
					ShowUpgrade = 3;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasLaserCannon && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).LaserCannonLevel < 3 )
					ShowUpgrade = 2;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasSlithTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SlithLevel < 3 )
					ShowUpgrade = 1;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasKrallTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).KrallLevel < 3 )
					ShowUpgrade = 0;
				}
			else if ( ShowUpgrade == 6 )
				{
				if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasRingOfFire && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).RingOfFireLevel < 3 )
					ShowUpgrade = 5;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasNali && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).NaliLevel < 3 )
					ShowUpgrade = 4;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasWarlord && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).WarlordLevel < 3 )
					ShowUpgrade = 3;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasLaserCannon && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).LaserCannonLevel < 3 )
					ShowUpgrade = 2;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasSlithTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SlithLevel < 3 )
					ShowUpgrade = 1;
				else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasKrallTower && PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).KrallLevel < 3 )
					ShowUpgrade = 0;
				}
			else if ( !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasCamoDetection )
				ShowUpgrade = 6;
			else
				ShowUpgrade = 999;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		//Music check:
		else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawMusicMenu && Titles[SelectedSong + 1] != "" )
			{
			if ( SelectedSong < 199 )
				{
				SelectedSong += 1;
				PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong = SelectedSong;
				PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
				}
			}
		//Vote menu check:
		if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawVoteMenu && MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 1] != "" )
			{
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum += 1;
			PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
			}
		bDownKeyPressed = True;
		}
	else if ( !PlayerPawn(Owner).bWasBack )
		bDownKeyPressed = False;

	//Player pressed LEFT arrow:
	if ( PlayerPawn(Owner).bWasLeft && !bLeftKeyPressed && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawMusicMenu)
		{
		bLeftKeyPressed = True;
		PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);
		if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawWeaponsMenu )
			{
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawWeaponsMenu = False;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawTowerMenu = True;
			}
		else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawTowerMenu )
			{
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawTowerMenu = False;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawUpgradeMenu = True;
			}
		else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawUpgradeMenu )
			{
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawUpgradeMenu = False;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawMusicMenu = True;
			}
		}
	else if ( !PlayerPawn(Owner).bWasLeft )
		{
		bLeftKeyPressed = False;
		}
	
	//Player pressed RIGHT arrow:
	if ( PlayerPawn(Owner).bWasRight && !bRightKeyPressed && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawWeaponsMenu )
		{
		bRightKeyPressed = True;
		PlayerPawn(Owner).ClientPlaySound(Sound'UMenu.LittleSelect', , true);	
		if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawTowerMenu )
			{
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawWeaponsMenu = True;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawTowerMenu = False;
			}
		else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawUpgradeMenu )
			{
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawTowerMenu = True;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawUpgradeMenu = False;
			}
		else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawMusicMenu )
			{
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawUpgradeMenu = True;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawMusicMenu = False;
			}
		}
	else if ( !PlayerPawn(Owner).bWasRight )
		{
		bRightKeyPressed = False;
		}
		
	
	if ( ShowUpgrade == 999 )
		bNoUpgradesAvailable = True;
	else
		bNoUpgradesAvailable = False;
}

function SetKeybinds()
{
local string KeyName,ID,Value,NewValue;
local PlayerPawn P;
local PBPRI PRI;
local int i;
local bool bMenuKeyAssigned;

	P = PlayerPawn(Owner);
	
	KeyName = P.ConsoleCommand( "KEYNAME "$13 );
	ID = P.ConsoleCommand( "KEYBINDING "$KeyName );
	Value = Right(ID,17);
	if ( InStr( Value, "SELECTPLAYER" ) == -1 )
		{
		//Assign menu buy item command to ENTER key:
		KeyName = P.ConsoleCommand( "KEYNAME "$13 );
		ID = P.ConsoleCommand( "KEYBINDING "$KeyName );
		NewValue = ID$" | mutate SELECTPLAYER";
		P.ConsoleCommand("SET Input"@KeyName@NewValue);
		}
	
	//Check if menu keybind is set, else assign keybind to F8
	for ( i=0;i<256;i++ )
		{
		KeyName = P.ConsoleCommand( "KEYNAME "$i );
		ID = Caps(P.ConsoleCommand( "KEYBINDING "$KeyName ));
		if ( InStr( ID, "MUTATE POPBALLOONSMENU" ) != -1 )
			{
			bMenuKeyAssigned = True;
			MenuKeyName = KeyName;
			//log("#PB# menu keybind assigned to:"@i$" keyname:"@KeyName);
			i = 999;
			}
		}
	if ( !bMenuKeyAssigned )
		{
		KeyName = P.ConsoleCommand( "KEYNAME "$119 );
		ID = P.ConsoleCommand( "KEYBINDING "$KeyName );
		Value = Right(ID,22);
		if ( InStr( Value, "POPBALLOONSMENU" ) == -1 )
			{
			//Assign menu open/close command to F8 key:
			KeyName = P.ConsoleCommand( "KEYNAME "$119 );
			ID = P.ConsoleCommand( "KEYBINDING "$KeyName );
			NewValue = ID$" | mutate POPBALLOONSMENU";
			P.ConsoleCommand("SET Input"@KeyName@NewValue);
			}
		}
}

function CreateKey()
{
local int i, ii, dice;

	Key = "";
	for (ii=0;ii<5;ii++)
		{
		for (i=0;i<5;i++)
			{
			Dice = Rand(10);
			Key = Key$Dice;
			}
		if ( ii < 4 )
			{
			Key = Key$"-";
			}
		}
}

simulated function DrawVoteMenu(Canvas Canvas)
{
local float XL,YL,XL2,YL2,XL3,YL3,Xpos,Ypos,FX,FY,FX2,FY2,MX,MY,MLX,MLY;
local Texture Screenshot;
local string Author, Difficulty;
local LevelSummary L;
local bool bBeaten;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	
	Xpos = (Canvas.ClipX - 800) * 0.5;
	Ypos = Canvas.ClipY * 0.5 - 250;
	
	DrawMenuBasics(Canvas, Xpos, Ypos, YL);
	
	Canvas.bCenter = True;
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.SetPos(1, Ypos + 1);
	Canvas.DrawText("Mapvote Menu", False);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("Mapvote Menu", False);
	
	//Draw frame around Screenshot
	FX = Xpos + XL + 10;
	FY = Canvas.ClipY * 0.5 - 128 - 35;
	Canvas.SetPos(FX, FY);
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.MapFrame', 256 + 70, 256 + 70, 0, 0, 512.0, 512.0);
	
	//Draw frame around maplist
	FX2 = Canvas.ClipX * 0.5 + 10;
	FY2 = Canvas.ClipY * 0.5 - 128 - 35;
	Canvas.SetPos(FX2, FY2);
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.MapFrame', 326, 326, 0, 0, 512.0, 512.0);
	
	//Draw map screenshot
	Screenshot = Texture(DynamicLoadObject("PB-"$MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum]$".unr.Screenshot", class'Texture'));
	Canvas.SetPos(FX + 35, FY + 35);
	if ( Screenshot != None )
		Canvas.DrawTile(Screenshot, 256, 256, 0, 0, Screenshot.USize, Screenshot.VSize);
	else
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.NoImage', 256, 256, 0, 0, 256, 256);

/*		
	//Check if map is beaten:
	if ( bBeaten )
		{
		Canvas.SetPos(FX + 35, FY + 35);
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.CompletedIcon', 256, 256, 0, 0, 256, 256);
		}
*/
	
	//Draw author:
	L = LevelSummary(DynamicLoadObject("PB-"$MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum]$".unr.LevelSummary", class'LevelSummary'));
	Author = L.Author;
	if ( Author == "" )
		Author = "N/A";
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos(1, Canvas.ClipY * 0.5 + 250 - 3*YL + 1);
	Canvas.DrawText("Author:"@Author, False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos(0, Canvas.ClipY * 0.5 + 250 - 3*YL);
	Canvas.DrawText("Author:"@Author, False);
	
	//Draw difficulty:
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Difficulty = L.LevelEnterText;
	if ( Difficulty == "" )
		Difficulty = "N/A";
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos(1, Canvas.ClipY * 0.5 + 250 - 2*YL + 1);
	Canvas.DrawText("Difficulty:"@Difficulty, False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos(0, Canvas.ClipY * 0.5 + 250 - 2*YL);
	Canvas.DrawText("Difficulty:"@Difficulty, False);
	
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	
	//Draw Map Title:
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos(0, Ypos + YL * 1.5);
	Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum], False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos(1, Ypos + 1 + YL * 1.5);
	Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum], False);
	
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	
	//Draw Map Difficulty:
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos(0, Ypos + 500 - YL * 2.75);
	//Canvas.DrawText("Difficulty:"@MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum].MapDifficulty, False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos(1, Ypos + 501 - YL * 2.75);
	//Canvas.DrawText("Difficulty:"@MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum].MapDifficulty, False);
	Canvas.bCenter = False;

	//DrawSelectedMap:
	MX = Canvas.ClipX * 0.5 + 175;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.StrLen(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum], MLX, MLY);
	MY = Canvas.ClipY * 0.5 - 0.5 * MLY;
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.SetPos(MX - 0.5 * MLX + 1, MY + 1);
	Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum], False);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(MX - 0.5 * MLX, MY);
	Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum], False);
	
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	
	//Draw next #1:
	if ( MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 1] != "" )
		{
		Canvas.StrLen(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 1], XL2, YL2);
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(MX - 0.5 * XL2 + 1, MY + MLY + 1);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 1], False);
		Canvas.DrawColor = WhiteColor * 0.85;
		Canvas.SetPos(MX - 0.5 * XL2, MY + MLY);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 1], False);
		}
	//Draw prior #1:
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum > 0 && MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 1] != "" )
		{
		Canvas.StrLen(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 1], XL2, YL2);
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(MX - 0.5 * XL2 + 1, MY - YL2 + 1);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 1], False);
		Canvas.DrawColor = WhiteColor * 0.85;
		Canvas.SetPos(MX - 0.5 * XL2, MY - YL2);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 1], False);
		}
	//Draw next #2:
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	if ( MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 2] != "" )
		{
		Canvas.StrLen(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 2], XL3, YL3);
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(MX - 0.5 * XL3 + 1, MY + MLY + YL2 + 1);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 2], False);
		Canvas.DrawColor = WhiteColor * 0.70;
		Canvas.SetPos(MX - 0.5 * XL3, MY + MLY + YL2);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 2], False);
		}
	//Draw prior #2:
	if (PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum > 1 && MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 2] != "")
		{
		Canvas.StrLen(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 2], XL3, YL3);
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(MX - 0.5 * XL3 + 1, MY - YL2 - YL3 + 1);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 2], False);
		Canvas.DrawColor = WhiteColor * 0.70;
		Canvas.SetPos(MX - 0.5 * XL3, MY - YL2 - YL3);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 2], False);
		}
	//Draw next #3:
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	if ( MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 3] != "" )
		{
		Canvas.StrLen(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 3], XL3, YL3);
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(MX - 0.5 * XL3 + 1, MY + MLY + YL2 + YL3 + 1);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 3], False);
		Canvas.DrawColor = WhiteColor * 0.55;
		Canvas.SetPos(MX - 0.5 * XL3, MY + MLY + YL2 + YL3);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 3], False);
		}
	//Draw prior #3:
	if (PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum > 2 && MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 3] != "")
		{
		Canvas.StrLen(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 3], XL3, YL3);
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(MX - 0.5 * XL3 + 1, MY - YL2 - 2*YL3 + 1);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 3], False);
		Canvas.DrawColor = WhiteColor * 0.55;
		Canvas.SetPos(MX - 0.5 * XL3, MY - YL2 - 2*YL3);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 3], False);
		}
	//Draw next #4:
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	if ( MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 4] != "" )
		{
		Canvas.StrLen(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 4], XL3, YL3);
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(MX - 0.5 * XL3 + 1, MY + MLY + YL2 + 2*YL3 + 1);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 4], False);
		Canvas.DrawColor = WhiteColor * 0.40;
		Canvas.SetPos(MX - 0.5 * XL3, MY + MLY + YL2 + 2*YL3);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum + 4], False);
		}
	//Draw prior #4:
	if (PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum > 3 && MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 4] != "")
		{
		Canvas.StrLen(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 4], XL3, YL3);
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(MX - 0.5 * XL3 + 1, MY - YL2 - 3*YL3 + 1);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 4], False);
		Canvas.DrawColor = WhiteColor * 0.40;
		Canvas.SetPos(MX - 0.5 * XL3, MY - YL2 - 3*YL3);
		Canvas.DrawText(MapList[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).MapNum - 4], False);
		}
			
	if ( PlayerPawn(Owner).Location != FixedLocation )
		PlayerPawn(Owner).SetLocation(FixedLocation);
}

//Draw menu: P.PBPRI booleans determine what to draw (bDrawWeaponsMenu,bDrawTowerMenu,bDrawUpgradeMenu,bDrawMusicMenu)
simulated function ShowMenu(Canvas Canvas)
{
local float XL,YL,Xpos,Ypos;
	
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	
	Xpos = (Canvas.ClipX - 800) * 0.5;
	Ypos = Canvas.ClipY * 0.5 - 250;
	
	DrawMenuBasics(Canvas, Xpos, Ypos, YL);
	DrawMenuCategories(Canvas, Xpos, Ypos, YL);
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawWeaponsMenu )
		DrawWeaponInfo(Canvas, Xpos, Ypos, YL,0,0);
	else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawTowerMenu )
		DrawTowerInfo(Canvas, Xpos, Ypos, XL, YL,0,0);
	else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawUpgradeMenu )
		DrawUpgradeInfo(Canvas, Xpos, Ypos, XL, YL,0,0);
	else if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawMusicMenu )
		DrawMusicInfo(Canvas, Xpos, Ypos, XL, YL,0,0);
	
	DrawMoney(Canvas);
	
	Canvas.bCenter = True;
	Canvas.SetPos(1, Canvas.ClipY * 0.5 - 251 - YL);
	Canvas.DrawColor = FadeColor * 0.0;
	Canvas.DrawText("Use your movement keys to navigate in the menu.", False);
	Canvas.SetPos(0, Canvas.ClipY * 0.5 - 250 - YL);
	Canvas.DrawColor = FadeColor;
	Canvas.DrawText("Use your movement keys to navigate in the menu.", False);
	Canvas.bCenter = False;
	
	if ( PlayerPawn(Owner).Location != FixedLocation )
		PlayerPawn(Owner).SetLocation(FixedLocation);
}

//Frame base 800x500 pixels
simulated function DrawMusicInfo(Canvas Canvas, float Xpos, float Ypos,float XL, float YL,float XL2, float YL2)
{
local string Song;
local float Y1,Y2;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;
	YL *= 1.5;
	
	/*
	function ClientSetMusic( music NewSong, byte NewSection, byte NewCdTrack, EMusicTransition NewTransition )
		{
		Song        = NewSong;
		SongSection = NewSection;
		CdTrack     = NewCdTrack;
		Transition  = NewTransition;
		}
		
	Songs[200];
	var String			Titles[200];
	var int				SelectedSong;
	*/

	Song = string(PlayerPawn(Owner).Song); // returns package.name e.g.: Botpck10.botpck10

	//Draw headline:
	Canvas.bCenter = True;
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos(1, Ypos + YL + 1);
	Canvas.DrawText("Select background music - press ENTER to select.", False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos(0, Ypos + YL);
	Canvas.DrawText("Select background music - press ENTER to select.", False);

	Canvas.StrLen("TEST", XL, YL);
	Y1 = Canvas.ClipY * 0.5 - 0.5 * YL + 1;	//point where prior songs are drawn from
	Y2 = Canvas.ClipY * 0.5 + 0.5 * YL;		//point where next songs are drawn from
	
	//DrawSelectedSong:
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.SetPos(1, Y1 + 1);
	Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong], False);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0, Y1);
	Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong], False);
	
	
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL2, YL2);
	
	//Draw next #1:
	if ( Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 1] != "" )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(1, Y2 + 1);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 1], False);
		Canvas.DrawColor = WhiteColor * 0.85;
		Canvas.SetPos(0, Y2);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 1], False);
		}
	//Draw next #2:
	if ( Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 2] != "" )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(1, Y2 + YL2 + 1);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 2], False);
		Canvas.DrawColor = WhiteColor * 0.70;
		Canvas.SetPos(0, Y2 + YL2);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 2], False);
		}
	//Draw next #3:
	if ( Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 3] != "" )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(1, Y2 + 2 * YL2 + 1);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 3], False);
		Canvas.DrawColor = WhiteColor * 0.55;
		Canvas.SetPos(0, Y2 + 2 * YL2);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 3], False);
		}
	//Draw next #4:
	if ( Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 4] != "" )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(1, Y2 + 3 * YL2 + 1);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 4], False);
		Canvas.DrawColor = WhiteColor * 0.40;
		Canvas.SetPos(0, Y2 + 3 * YL2);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 4], False);
		}
	//Draw next #5:
	if ( Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 5] != "" )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(1, Y2 + 4 * YL2 + 1);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 5], False);
		Canvas.DrawColor = WhiteColor * 0.25;
		Canvas.SetPos(0, Y2 + 4 * YL2);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong + 5], False);
		}	
	//Draw prior #1:
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong > 0 )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(1, Y1 - YL2 + 1);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong - 1], False);
		Canvas.DrawColor = WhiteColor * 0.85;
		Canvas.SetPos(0, Y1 - YL2);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong - 1], False);
		}
	//Draw prior #2:
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong > 1 )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(1, Y1 - 2 * YL2 + 1);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong - 2], False);
		Canvas.DrawColor = WhiteColor * 0.70;
		Canvas.SetPos(0, Y1 - 2 * YL2);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong - 2], False);
		}
	//Draw prior #3:
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong > 2 )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(1, Y1 - 3 * YL2 + 1);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong - 3], False);
		Canvas.DrawColor = WhiteColor * 0.55;
		Canvas.SetPos(0, Y1 - 3 * YL2);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong - 3], False);
		}
	//Draw prior #4:
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong > 3 )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(1, Y1 - 4 * YL2 + 1);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong - 4], False);
		Canvas.DrawColor = WhiteColor * 0.40;
		Canvas.SetPos(0, Y1 - 4 * YL2);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong - 4], False);
		}
	//Draw prior #5:
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong > 4 )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(1, Y1 - 5 * YL2 + 1);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong - 5], False);
		Canvas.DrawColor = WhiteColor * 0.25;
		Canvas.SetPos(0, Y1 - 5 * YL2);
		Canvas.DrawText(Titles[PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedSong - 5], False);
		}
		
	Canvas.bCenter = False;
}

//Frame base 800x500 pixels
simulated function DrawTowerInfo(Canvas Canvas, float Xpos, float Ypos,float XL, float YL,float XL2, float YL2)
{
local bool 	bCanBuyTower,
			bPlayerHasTowerInv;
local Inventory Inv;

	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if (Inv.IsA('Weapon_Tower')) 
			{
			bPlayerHasTowerInv = True;
			}
		}
		
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	YL *= 1.5;
	
	//TowerName(0)="Tower of the Krall"
	//TowerString1(0)="A weak but steady defence."
	//TowerString2(0)="Fires electric bolts towards all balloon types."
	//TowerPrice(0)=1000	
	//ShowTower: 0=Krall, 1=Slith
	
	Canvas.Style = ERenderStyle.STY_Masked;
	if ( ShowTower == 0 )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Xpos + XL + 2, Ypos + 2);
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_Krall', 256, 512, 0, 0, 256.0, 512.0);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Xpos + XL, Ypos );
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_Krall', 256, 512, 0, 0, 256.0, 512.0);
		}
	else if ( ShowTower == 1 )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Xpos + XL + 2, Ypos + 2);
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_Slith', 256, 512, 0, 0, 256.0, 512.0);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Xpos + XL, Ypos );
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_Slith', 256, 512, 0, 0, 256.0, 512.0);
		}
	else if ( ShowTower == 2 )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Xpos + XL + 2, Ypos + 2);
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_LaserCannon', 256, 512, 0, 0, 256.0, 512.0);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Xpos + XL, Ypos );
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_LaserCannon', 256, 512, 0, 0, 256.0, 512.0);
		}
	else if ( ShowTower == 3 )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Xpos + XL + 2, Ypos + 2);
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_Warlord', 256, 512, 0, 0, 256.0, 512.0);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Xpos + XL, Ypos );
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_Warlord', 256, 512, 0, 0, 256.0, 512.0);
		}
	else if ( ShowTower == 4 )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Xpos + XL + 2, Ypos + 2);
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_Nali', 256, 512, 0, 0, 256.0, 512.0);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Xpos + XL, Ypos );
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_Nali', 256, 512, 0, 0, 256.0, 512.0);
		}
	else if ( ShowTower == 5 )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Xpos + XL + 2, Ypos + 2);
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_RingOfFire', 256, 512, 0, 0, 256.0, 512.0);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Xpos + XL, Ypos );
		Canvas.DrawTile(Texture'PopBalloonsTextures.Towers.Icon_RingOfFire', 256, 512, 0, 0, 256.0, 512.0);
		}
	Canvas.Style = ERenderStyle.STY_Normal;
	
	//Draw tower name:
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos(Xpos + XL + 256 + 1, Ypos + YL + 1);
	Canvas.DrawText(TowerName[ShowTower], False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos(Xpos + XL + 256, Ypos + YL);
	Canvas.DrawText(TowerName[ShowTower], False);
	
	//Draw tower string1:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL2, YL2);
	Canvas.DrawColor = GreenColor * 0.1;
	Canvas.SetPos(Xpos + XL + 256 + 1, Ypos + YL + 1 + 2 * YL2);
	Canvas.DrawText(TowerString1[ShowTower], False);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos(Xpos + XL + 256, Ypos + YL + 2 * YL2);
	Canvas.DrawText(TowerString1[ShowTower], False);
	
	//Draw tower string2:
	Canvas.DrawColor = GreenColor * 0.1;
	Canvas.SetPos(Xpos + XL + 256 + 1, Ypos + YL + 1 + 4 * YL2);
	Canvas.DrawText(TowerString2[ShowTower], False);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos(Xpos + XL + 256, Ypos + YL + 4 * YL2);
	Canvas.DrawText(TowerString2[ShowTower], False);

	//Draw tower price according to players ability to buy it:
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).Score < TowerPrice[ShowTower])
		{
		Canvas.DrawColor = RedColor * 0.1;
		Canvas.SetPos(Xpos + XL + 256 + 1, Ypos + YL + 1 + 6 * YL2);
		Canvas.DrawText("Cost: $"$TowerPrice[ShowTower], False);
		Canvas.DrawColor = RedColor;
		Canvas.SetPos(Xpos + XL + 256, Ypos + YL + 6 * YL2);
		Canvas.DrawText("Cost: $"$TowerPrice[ShowTower], False);
		}
	else
		{
		Canvas.SetPos(Xpos + XL + 256 + 1, Ypos + YL + 1 + 6 * YL2);
		Canvas.DrawColor = GreenColor * 0.1;
		Canvas.DrawText("Cost: $"$TowerPrice[ShowTower], False);
		Canvas.SetPos(Xpos + XL + 256, Ypos + YL + 6 * YL2);
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText("Cost: $"$TowerPrice[ShowTower], False);
		bCanBuyTower = True;
		}
	
	//Draw tower notice according to if player can buy or already have bought a tower
	if ( bCanBuyTower )
		{
		Canvas.bCenter = True;
		//Check if player has tower already:
		if ( bPlayerHasTowerInv )
			{
			Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("You must place tower before you can buy another.", False);
			Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("You must place tower before you can buy another.", False);
			}
		else
			{
			Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("Press ENTER to buy tower.", False);
			Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("Press ENTER to buy tower.", False);
			}
		Canvas.bCenter = False;
		}
	
	PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedTower = ShowTower;
}

//Frame base 800x500 pixels
simulated function DrawUpgradeInfo(Canvas Canvas, float Xpos, float Ypos,float XL, float YL,float XL2, float YL2)
{
local bool 	bCanBuyUpgrade, bHasKrallSightRadius;
local PBPRI PRI;

	PRI = PBPRI(PlayerPawn(Owner).PlayerReplicationInfo);
		
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	YL *= 1.5;
	
	/*
	Upgrades: 0=Krall, 1=Slith
	*/
	
	Canvas.Style = ERenderStyle.STY_Masked;
	
	//Check if no upgrade is available:
	if ( bNoUpgradesAvailable )
		{
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
		Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.NoUpdates', 256, 256, 0, 0, 256.0, 256.0);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Xpos + XL, Ypos + 125);
		Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.NoUpdates', 256, 256, 0, 0, 256.0, 256.0);
		Canvas.DrawColor = GoldColor * 0.1;
		Canvas.bCenter = True;
		Canvas.SetPos(1, Ypos + YL);
		Canvas.DrawText("No upgrades available!", False);
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, Ypos + YL);
		Canvas.DrawText("No upgrades available!", False);
		Canvas.bCenter = False;
		}
	//Tower_Krall upgrades:
	else if ( ShowUpgrade == 0 && PRI.bHasKrallTower )
		{
		if ( PRI.KrallLevel < 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.LineOfSight', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.LineOfSight', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Krall Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Krall Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 1 upgrade: Line of sight.", False);
			if ( PRI.Score >= 500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 1 upgrade: Line of sight.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Enhanced tower sight radius.", False);
			if ( PRI.Score >= 500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Enhanced tower sight radius.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $500", False);
			if ( PRI.Score >= 500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $500", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 500 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Krall towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Krall towers.", False);
				}
			Canvas.bCenter = False;
			}
		else if ( PRI.KrallLevel == 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.ExplosiveShell', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.ExplosiveShell', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Krall Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Krall Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 2 upgrade: Explosive Shell.", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 2 upgrade: Explosive Shell.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Projectile now explodes on impact.", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Projectile now explodes on impact.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $750", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $750", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 750 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Krall towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Krall towers.", False);
				}
			Canvas.bCenter = False;
			}
		else if ( PRI.KrallLevel == 2 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.DoubleFirepower', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.DoubleFirepower', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Krall Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Krall Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 3 upgrade: Double Firepower.", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 3 upgrade: Double Firepower.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Fires against two targets if within range.", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Fires against two targets if within range.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $1000", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $1000", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 1000 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Krall towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Krall towers.", False);
				}
			Canvas.bCenter = False;
			}
		}
	//Tower_Slith upgrades:
	else if ( ShowUpgrade == 1 && PRI.bHasSlithTower )
		{
		if ( PRI.SlithLevel < 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.LineOfSight', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.LineOfSight', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Slith Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Slith Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 1 upgrade: Line of sight.", False);
			if ( PRI.Score >= 500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 1 upgrade: Line of sight.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Enhanced tower sight radius.", False);
			if ( PRI.Score >= 500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Enhanced tower sight radius.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $500", False);
			if ( PRI.Score >= 500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $500", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 500 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Slith towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Slith towers.", False);
				}
			}
		if ( PRI.SlithLevel == 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.Poison', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.Poison', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Slith Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Slith Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 2 upgrade: Poison.", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 2 upgrade: Poison.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Inflicts target with poson.", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Inflicts target with poison.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $750", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $750", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 750 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Slith towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Slith towers.", False);
				}
			Canvas.bCenter = False;
			}
		else if ( PRI.SlithLevel == 2 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.DoubleFirepower', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.DoubleFirepower', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Slith Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Slith Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 3 upgrade: Double Firepower.", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 3 upgrade: Double Firepower.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Fires against two targets if within range.", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Fires against two targets if within range.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $1000", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $1000", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 1000 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Slith towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Slith towers.", False);
				}
			Canvas.bCenter = False;
			}
		}
	//Tower_LaserCannon upgrades:
	else if ( ShowUpgrade == 2 && PRI.bHasLaserCannon )
		{
		if ( PRI.LaserCannonLevel < 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.FasterFireSpeed', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.FasterFireSpeed', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Laser Cannon Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Laser Cannon Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 1 upgrade: Weapon Boost.", False);
			if ( PRI.Score >= 400 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 1 upgrade: Weapon Boost.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Enhanced firing speed and sight radius.", False);
			if ( PRI.Score >= 400 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Enhanced firing speed and sight radius.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $400", False);
			if ( PRI.Score >= 400 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $400", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 400 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Laser Cannon towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Laser Cannon towers.", False);
				}
			}
		if ( PRI.LaserCannonLevel == 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.FasterFireSpeed', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.FasterFireSpeed', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Laser Cannon Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Laser Cannon Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 2 upgrade: Weapon Boost.", False);
			if ( PRI.Score >= 500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 2 upgrade: Weapon Boost.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Enhanced firing speed and sight radius.", False);
			if ( PRI.Score >= 500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Enhanced firing speed and sight radius.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $500", False);
			if ( PRI.Score >= 500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $500", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 500 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Laser Cannon towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Laser Cannon towers.", False);
				}
			Canvas.bCenter = False;
			}
		else if ( PRI.LaserCannonLevel == 2 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.FasterFireSpeed', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.FasterFireSpeed', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Laser Cannon Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Laser Cannon Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 3 upgrade: Weapon Boost.", False);
			if ( PRI.Score >= 600 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 3 upgrade: Weapon Boost.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Enhanced firing speed and sight radius.", False);
			if ( PRI.Score >= 600 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Enhanced firing speed and sight radius.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $600", False);
			if ( PRI.Score >= 600 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $600", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 600 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Laser Cannon towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Laser Cannon towers.", False);
				}
			Canvas.bCenter = False;
			}
		}
	//Tower_Warlord upgrades:
	else if ( ShowUpgrade == 3 && PRI.bHasWarlord )
		{
		if ( PRI.WarlordLevel < 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.ExplosiveShell', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.ExplosiveShell', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Warlord Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Warlord Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 1 upgrade: Speed'n'Blast.", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 1 upgrade: Speed'n'Blast.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Enhanced firing speed and bigger rockets.", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Enhanced firing speed and bigger rockets.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $1000", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $1000", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 1000 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Warlord towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Warlord towers.", False);
				}
			}
		if ( PRI.WarlordLevel == 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.EvilShell', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.EvilShell', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Warlord Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Warlord Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 2 upgrade: Evil Speed.", False);
			if ( PRI.Score >= 1500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 2 upgrade: Evil Speed.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Enhanced firing speed and evil rockets.", False);
			if ( PRI.Score >= 1500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Enhanced firing speed and evil rockets.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $1500", False);
			if ( PRI.Score >= 1500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $1500", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 1500 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Warlord towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Warlord towers.", False);
				}
			Canvas.bCenter = False;
			}
		else if ( PRI.WarlordLevel == 2 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.DemolitionShell', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.DemolitionShell', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Warlord Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Warlord Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 3 upgrade: Demolition.", False);
			if ( PRI.Score >= 2000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 3 upgrade: Demolition.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Enhanced firing speed and max firepower!", False);
			if ( PRI.Score >= 2000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Enhanced firing speed and max firepower!", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $2000", False);
			if ( PRI.Score >= 2000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $2000", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 2000 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Warlord towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Warlord towers.", False);
				}
			Canvas.bCenter = False;
			}
		}
	//Tower_Nali upgrades:
	else if ( ShowUpgrade == 4 && PRI.bHasNali )
		{
		if ( PRI.NaliLevel < 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.Frozen1', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.Frozen1', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Nali Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Nali Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 1 upgrade: Double up.", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 1 upgrade: Double up.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Target is now slowed 50%.", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Target is now slowed 50%.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $750", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $750", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 750 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Nali towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Nali towers.", False);
				}
			}
		if ( PRI.NaliLevel == 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.Frozen2', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.Frozen2', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Nali Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Nali Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 2 upgrade: Hand brake.", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 2 upgrade: Hand brake.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Target is now slowed 75%.", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Target is now slowed 75%.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $750", False);
			if ( PRI.Score >= 750 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $750", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 750 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Nali towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Nali towers.", False);
				}
			Canvas.bCenter = False;
			}
		else if ( PRI.NaliLevel == 2 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.Frozen3', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.Frozen3', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Nali Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Nali Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 3 upgrade: Icecube.", False);
			if ( PRI.Score >= 1250 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 3 upgrade: Icecube.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Target now freezes for 5 seconds.", False);
			if ( PRI.Score >= 1250 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Target now freezes for 5 seconds.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $1250", False);
			if ( PRI.Score >= 1250 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $1250", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 1250 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Nali towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Nali towers.", False);
				}
			Canvas.bCenter = False;
			}
		}
	//Tower_RingOfFire upgrades:
	else if ( ShowUpgrade == 5 && PRI.bHasRingOfFire )
		{
		if ( PRI.RingOfFireLevel < 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.RingOfFire1', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.RingOfFire1', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Ring Of Fire Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Ring Of Fire Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 1 upgrade: More Flames.", False);
			if ( PRI.Score >= 1250 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 1 upgrade: More Flames.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Towers fires 50% more flameballs.", False);
			if ( PRI.Score >= 1250 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Towers fires 50% more flameballs.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $1250", False);
			if ( PRI.Score >= 1250 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $1250", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 1250 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Ring Of Fire towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Ring Of Fire towers.", False);
				}
			}
		if ( PRI.RingOfFireLevel == 1 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.RingOfFire2', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.RingOfFire2', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Ring Of Fire Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Ring Of Fire Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 2 upgrade: More & Bigger Fireballs.", False);
			if ( PRI.Score >= 1500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 2 upgrade: More & Bigger Fireballs.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("50% more and bigger fireballs.", False);
			if ( PRI.Score >= 1500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("50% more and bigger fireballs.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $1500", False);
			if ( PRI.Score >= 1500 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $1500", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 1500 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Ring Of Fire towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Ring Of Fire towers.", False);
				}
			Canvas.bCenter = False;
			}
		else if ( PRI.RingOfFireLevel == 2 )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.RingOfFire3', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.RingOfFire3', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Tower upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Ring Of Fire Tower Upgrades", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Ring Of Fire Tower Upgrades", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Level 3 upgrade: Breath Of The Dragon.", False);
			if ( PRI.Score >= 2000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Level 3 upgrade: Breath Of The Dragon.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Maximum Firepower!", False);
			if ( PRI.Score >= 2000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Maximum Firepower!", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $2000", False);
			if ( PRI.Score >= 2000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $2000", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 2000 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to upgrade your Ring Of Fire towers.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to upgrade your Ring Of Fire towers.", False);
				}
			Canvas.bCenter = False;
			}
		}
	//Camo Detection upgrade:
	else if ( ShowUpgrade == 6 )
		{
		if ( !PRI.bHasCamoDetection )
			{
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Xpos + XL + 2, Ypos + 127);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.CamoDetection', 256, 256, 0, 0, 256.0, 256.0);
			Canvas.DrawColor = WhiteColor;
			Canvas.SetPos(Xpos + XL, Ypos + 125);
			Canvas.DrawTile(Texture'PopBalloonsTextures.Upgrades.CamoDetection', 256, 256, 0, 0, 256.0, 256.0);
			//Draw Camo Detection upgrade:
			Canvas.DrawColor = GoldColor * 0.1;
			Canvas.bCenter = True;
			Canvas.SetPos(1, Ypos + YL);
			Canvas.DrawText("Camo Detection Upgrade", False);
			Canvas.DrawColor = GoldColor;
			Canvas.SetPos(0, Ypos + YL);
			Canvas.DrawText("Camo Detection Upgrade", False);
			Canvas.bCenter = False;
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 3 * YL - 1);
			Canvas.DrawText("Allows your weapons to pop camo balloons.", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 3 * YL);
			Canvas.DrawText("Allows your weapons to pop camo balloons.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 4 * YL - 1);
			Canvas.DrawText("Allows your towers to pop camo balloons.", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 4 * YL);
			Canvas.DrawText("Allows your towers to pop camo balloons.", False);
			
			Canvas.DrawColor = WhiteColor * 0.1;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 63, Ypos + 5 * YL - 1);
			Canvas.DrawText("Price: $1000", False);
			if ( PRI.Score >= 1000 )
				Canvas.DrawColor = GreenColor;
			else
				Canvas.DrawColor = RedColor;
			Canvas.SetPos(Canvas.ClipX * 0.5 - 64, Ypos + 5 * YL);
			Canvas.DrawText("Price: $1000", False);
			
			Canvas.bCenter = True;
			if ( PRI.Score < 1000 )
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = RedColor * 0.0;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = RedColor;
				Canvas.DrawText("You can't afford this upgrade yet.", False);
				}
			else
				{
				Canvas.SetPos(1, Canvas.ClipY * 0.5 + 192);
				Canvas.DrawColor = FadeColor * 0.0;
				Canvas.DrawText("Press ENTER to be able to pop camo balloons.", False);
				Canvas.SetPos(0, Canvas.ClipY * 0.5 + 191);
				Canvas.DrawColor = FadeColor;
				Canvas.DrawText("Press ENTER to be able to pop camo balloons.", False);
				}
			}
		}
	PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedUpgrade = ShowUpgrade;
}

simulated function DrawWeaponInfo(Canvas Canvas, float Xpos, float Ypos,float YL,float XL2, float YL2)
{
local bool bCanBuyWeapon;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	YL *= 1.5;
	
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Xpos + 400 - 128, Ypos + YL);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cBlack', 256, 128, 0, 0, 256.0, 128.0);
	Canvas.SetPos(Xpos + 400 - 128, Ypos + YL);
	Canvas.DrawTile(PBWeapon[ShowWeapon], 256, 128, 0, 0, 256.0, 128.0);
	Canvas.SetPos(Xpos + 400 - 129, Ypos + YL - 1);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 258, 1, 0, 0, 1.0, 1.0);
	Canvas.SetPos(Xpos + 400 - 129, Ypos + YL + 128);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 258, 1, 0, 0, 1.0, 1.0);
	Canvas.SetPos(Xpos + 400 - 129, Ypos + YL);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 1, 128, 0, 0, 1.0, 1.0);
	Canvas.SetPos(Xpos + 528, Ypos + YL);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 1, 128, 0, 0, 1.0, 1.0);
	
	Canvas.bCenter = True;
	
	//Draw weapon name:
	Canvas.DrawColor = GoldColor * 0.1;
	Canvas.SetPos(1, Ypos + 137 + YL);
	Canvas.DrawText(WeaponString1[ShowWeapon], False);
	Canvas.DrawColor = GoldColor;
	Canvas.SetPos(0, Ypos + 136 + YL);
	Canvas.DrawText(WeaponString1[ShowWeapon], False);
	
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL2, YL2);
	
	//Draw what type of ballons the weapon can pop:
	Canvas.DrawColor = GreenColor * 0.1;
	Canvas.SetPos(1, Ypos + 137 + 2 * YL);
	Canvas.DrawText(WeaponString3[ShowWeapon], False);
	Canvas.DrawColor = GreenColor;
	Canvas.SetPos(0, Ypos + 136 + 2 * YL);
	Canvas.DrawText(WeaponString3[ShowWeapon], False);
	
	//Draw what the weapon costs:
	if ( ShowWeapon != 0 )
		{
		Canvas.DrawColor = GreenColor * 0.1;
		Canvas.SetPos(1, Ypos + 137 + 2 * YL + YL2);
		Canvas.DrawText(WeaponString2[ShowWeapon], False);
		Canvas.DrawColor = GreenColor;
		Canvas.SetPos(0, Ypos + 136 + 2 * YL + YL2);
		Canvas.DrawText(WeaponString2[ShowWeapon], False);
		}
	
	//Draw what rank the weapon unlocks or price if unlocked:
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).Rank < UnlockRank[ShowWeapon] && ShowWeapon != 0)
		{
		Canvas.DrawColor = RedColor * 0.1;
		Canvas.SetPos(1, Ypos + 137 + 2 * YL + 2 * YL2);
		Canvas.DrawText("Unlocks at rank:"@UnlockRank[ShowWeapon], False);
		Canvas.DrawColor = RedColor;
		Canvas.SetPos(0, Ypos + 136 + 2 * YL + 2 * YL2);
		Canvas.DrawText("Unlocks at rank:"@UnlockRank[ShowWeapon], False);
		}
	else if ( PlayerPawn(Owner).PlayerReplicationInfo.Score >= WeaponPrice[ShowWeapon] && ShowWeapon != 0)
		{
		Canvas.SetPos(1, Ypos + 137 + 2 * YL + 2 * YL2);
		Canvas.DrawColor = GreenColor * 0.1;
		Canvas.DrawText("Price: $"$WeaponPrice[ShowWeapon], False);
		Canvas.SetPos(0, Ypos + 136 + 2 * YL + 2 * YL2);
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText("Price: $"$WeaponPrice[ShowWeapon], False);
		bCanBuyWeapon = True;
		}
	else if ( ShowWeapon != 0 )
		{
		Canvas.SetPos(1, Ypos + 137 + 2 * YL + 2 * YL2);
		Canvas.DrawColor = RedColor * 0.1;
		Canvas.DrawText("Price: $"$WeaponPrice[ShowWeapon], False);
		Canvas.SetPos(0, Ypos + 136 + 2 * YL + 2 * YL2);
		Canvas.DrawColor = RedColor;
		Canvas.DrawText("Price: $"$WeaponPrice[ShowWeapon], False);
		}
	
	//Draw info about how many layers the weapon pop each succesful shot:
	Canvas.SetPos(1, Ypos + 137 + 2 * YL + 3 * YL2);
	Canvas.DrawColor = GreenColor * 0.1;
	Canvas.DrawText("Layers popped primary fire:"@PriLayersPopped[ShowWeapon], False);
	Canvas.SetPos(0, Ypos + 136 + 2 * YL + 3 * YL2);
	Canvas.DrawColor = GreenColor;
	Canvas.DrawText("Layers popped primary fire:"@PriLayersPopped[ShowWeapon], False);
	Canvas.SetPos(1, Ypos + 137 + 2 * YL + 4 * YL2);
	Canvas.DrawColor = GreenColor * 0.1;
	Canvas.DrawText("Layers popped alt fire:"@AltLayersPopped[ShowWeapon], False);
	Canvas.SetPos(0, Ypos + 136 + 2 * YL + 4 * YL2);
	Canvas.DrawColor = GreenColor;
	Canvas.DrawText("Layers popped alt fire:"@AltLayersPopped[ShowWeapon], False);
	
	//Draw additional weapon info:
	Canvas.SetPos(1, Ypos + 137 + 2 * YL + 5 * YL2);
	Canvas.DrawColor = GreenColor * 0.1;
	Canvas.DrawText(DescriptionString1[ShowWeapon], False);
	Canvas.SetPos(0, Ypos + 136 + 2 * YL + 5 * YL2);
	Canvas.DrawColor = GreenColor;
	Canvas.DrawText(DescriptionString1[ShowWeapon], False);
	Canvas.SetPos(1, Ypos + 137 + 2 * YL + 6 * YL2);
	Canvas.DrawColor = GreenColor * 0.1;
	Canvas.DrawText(DescriptionString2[ShowWeapon], False);
	Canvas.SetPos(0, Ypos + 136 + 2 * YL + 6 * YL2);
	Canvas.DrawColor = GreenColor;
	Canvas.DrawText(DescriptionString2[ShowWeapon], False);
	
	//Draw Press enter to buy weapon notice
	if ( bCanBuyWeapon )
		{
		//Check if player has weapon already:
		if ( ShowWeapon == 1 && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasBiorifle )
			{
			Canvas.SetPos(1, Ypos + 501 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			Canvas.SetPos(0, Ypos + 500 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			}
		else if ( ShowWeapon == 2 && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasShockRifle )
			{
			Canvas.SetPos(1, Ypos + 501 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			Canvas.SetPos(0, Ypos + 500 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			}
		else if ( ShowWeapon == 3 && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasPulseGun )
			{
			Canvas.SetPos(1, Ypos + 501 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			Canvas.SetPos(0, Ypos + 500 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			}
		else if ( ShowWeapon == 4 && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasRazorJack )
			{
			Canvas.SetPos(1, Ypos + 501 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			Canvas.SetPos(0, Ypos + 500 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			}
		else if ( ShowWeapon == 5 && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasFlakCannon )
			{
			Canvas.SetPos(1, Ypos + 501 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			Canvas.SetPos(0, Ypos + 500 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			}
		else if ( ShowWeapon == 6 && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasRocketLauncher )
			{
			Canvas.SetPos(1, Ypos + 501 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			Canvas.SetPos(0, Ypos + 500 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			}
		else if ( ShowWeapon == 7 && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasSniperRifle )
			{
			Canvas.SetPos(1, Ypos + 501 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			Canvas.SetPos(0, Ypos + 500 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			}
		else if ( ShowWeapon == 8 && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasMinigun )
			{
			Canvas.SetPos(1, Ypos + 501 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			Canvas.SetPos(0, Ypos + 500 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			}
		else if ( ShowWeapon == 9 && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasUzi )
			{
			Canvas.SetPos(1, Ypos + 501 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			Canvas.SetPos(0, Ypos + 500 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			}
		else if ( ShowWeapon == 10 && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bHasColdBreeze )
			{
			Canvas.SetPos(1, Ypos + 501 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor * 0.0;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			Canvas.SetPos(0, Ypos + 500 - YL - 2.25 * YL2);
			Canvas.DrawColor = FadeColor;
			Canvas.DrawText("Press ENTER to buy weapon.", False);
			}
		}
			
	PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).SelectedWeapon = ShowWeapon;
}

//Frame base 800x500 pixels
simulated function DrawMenuBasics(Canvas Canvas, float Xpos, float Ypos,float YL)
{	
	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	YL *= 1.25;
	
	Canvas.SetPos(Xpos - 1, Ypos - 1);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 802, 1, 0, 0, 1.0, 1.0);
	Canvas.SetPos(Xpos - 1, Ypos );
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 1, 500, 0, 0, 1.0, 1.0);
	Canvas.SetPos(Xpos + 800, Ypos );
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 1, 500, 0, 0, 1.0, 1.0);
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.FrameBaseBlue', 800, 500, 0, 0, 800.0, 500.0);
	Canvas.SetPos(Xpos + YL, Ypos + YL );
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.FrameBaseBW', 800 - 2 * YL, 500 - 2 * YL, YL, YL, 800 - 2 * YL, 500 - 2 * YL);
	Canvas.SetPos(Xpos + YL, Ypos + YL);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 800 - 2 * YL, 1, 0, 0, 1.0, 1.0);
	Canvas.SetPos(Xpos + YL, Ypos + 500 - YL);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 801 - 2 * YL, 1, 0, 0, 1.0, 1.0);
	Canvas.SetPos(Xpos + YL, Ypos + YL );
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 1, 500 - 2 * YL, 0, 0, 1.0, 1.0);
	Canvas.SetPos(Xpos + 800 - YL, Ypos + YL );
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 1, 500 - 2 * YL, 0, 0, 1.0, 1.0);
	Canvas.SetPos(Xpos - 1, Ypos + 500);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cWhite', 802, 1, 0, 0, 1.0, 1.0);
	
	Canvas.Style = ERenderStyle.STY_Masked;
	
	//Draw Up navigation arrow
	Canvas.SetPos(Xpos , Ypos + 248 - YL);
	if ( bUpKeyPressed )
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.ArrowsOn', YL, YL, 82, 0, 92.0, 92.0);
	else
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Arrows', YL, YL, 82, 0, 92.0, 92.0);
		
	//Draw Down navigation arrow
	Canvas.SetPos(Xpos , Ypos + 252);
	if ( bDownKeyPressed )
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.ArrowsOn', YL, YL, 82, 256 - 92, 92.0, 92.0);
	else
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Arrows', YL, YL, 82, 256 - 92, 92.0, 92.0);
	
	//Draw Left navigation arrow
	Canvas.SetPos(Xpos + 398 - YL, Ypos + 501 - YL);
	if ( bRightKeyPressed )
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.ArrowsOn', YL, YL, 0, 82, 92.0, 92.0);
	else
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Arrows', YL, YL, 0, 82, 92.0, 92.0);
	
	//Draw Right navigation arrow
	Canvas.SetPos(Xpos + 402, Ypos + 501 - YL);
	if ( bLeftKeyPressed )
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.ArrowsOn', YL, YL, 256 - 92, 82, 92.0, 92.0);
	else
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Arrows', YL, YL, 256 - 92, 82, 92.0, 92.0);
	
}

simulated function DrawMenuCategories(Canvas Canvas, float Xpos, float Ypos, float YL)
{
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Xpos += YL;
	
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawWeaponsMenu )
		Canvas.DrawColor = WhiteColor;
	else
		Canvas.DrawColor = WhiteColor * 0.3;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawText("Weapons ", False);
	
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawTowerMenu )
		Canvas.DrawColor = WhiteColor;
	else
		Canvas.DrawColor = WhiteColor * 0.3;
	Canvas.SetPos(Canvas.CurX, Ypos);
	Canvas.DrawText("Towers ", False);
	
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawUpgradeMenu )
		Canvas.DrawColor = WhiteColor;
	else
		Canvas.DrawColor = WhiteColor * 0.3;
	Canvas.SetPos(Canvas.CurX, Ypos);
	Canvas.DrawText("Upgrades ", False);
	
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawMusicMenu )
		Canvas.DrawColor = WhiteColor;
	else
		Canvas.DrawColor = WhiteColor * 0.3;
	Canvas.SetPos(Canvas.CurX, Ypos);
	Canvas.DrawText("Music ", False);
}

simulated function DrawPBInfo(Canvas Canvas)
{
local float XL,YL;
local float Xpos,Ypos,Scale;
local GRI GRI;
local int i;

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;
	
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.StrLen("TEST", XL, YL);
	Canvas.bCenter = True;
	GRI = GRI(PlayerOwner.GameReplicationInfo);
	
	//first check if screen resolution is big eneough:
	if ( Canvas.ClipX < 800 || Canvas.ClipY < 600 )
		{
		Canvas.SetPos(0, YL);
		Canvas.DrawText("!!Your resolution is too small!!", False);
		Canvas.SetPos(0, 3 * YL);
		Canvas.DrawText("Minimum supported is 800x600", False);
		Canvas.bCenter = False;
		Return;
		}
	
	Canvas.SetPos(0, 0);
	Canvas.DrawText("Pop Them Friggin Balloons Beta3", False);
	
}

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

simulated function PostBeginPlay()
{
	local int i;

	if ( Level.NetMode != NM_Standalone )
		MOTDFadeOutTime = 350;
	FaceAreaOffset = -64;
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(FontInfoClass, class'Class'))));
	Super.PostBeginPlay();
	SetTimer(1.0, True);

	bDrawVictory = False;
	bPlayVictory = False;
	VictoryDrawTime = 5;
	
	if ( (PlayerPawn(Owner).GameReplicationInfo != None)
		&& (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

	ServerInfo = Spawn(ServerInfoClass, Owner);
	SetKeybinds();
	SaveConfig();
}

exec function ShowServerInfo()
{
	if (bShowInfo)
	{
		bShowInfo = False;
	} else {
		bShowInfo = True;
		PlayerPawn(Owner).bShowScores = False;
	}
}

simulated function ChangeCrosshair(int d)
{
	Crosshair = Crosshair + d;
	if ( Crosshair >= CrossHairCount )
		Crosshair = 0;
	else
	if ( Crosshair < 0 )
		Crosshair = CrossHairCount-1;
}

simulated function Texture LoadCrosshair(int c)
{
	CrossHairTextures[c] = Texture(DynamicLoadObject(CrossHairs[c], class'Texture'));
	return CrossHairTextures[c];
}

simulated function HUDSetup(canvas canvas)
{
	local int FontSize;

	bResChanged = (Canvas.ClipX != OldClipX);
	OldClipX = Canvas.ClipX;
		
	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner.ViewTarget == None )
		PawnOwner = PlayerOwner;
	else if ( PlayerOwner.ViewTarget.bIsPawn )
		PawnOwner = Pawn(PlayerOwner.ViewTarget);
	else 
		PawnOwner = PlayerOwner;

	// Setup the way we want to draw all HUD elements
	Canvas.Reset();
	Canvas.SpaceX=0;
	Canvas.bNoSmooth = True;

	FontSize = Min(3, HUDScale * Canvas.ClipX/500);
	Scale = (HUDScale * Canvas.ClipX)/1280.0;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	SolidHUDColor = FavoriteHUDColor * 15.9;
	if ( (Opacity == 16) || !Level.bHighDetailMode )
	{
		Style = ERenderStyle.STY_Normal;
		BaseColor = WhiteColor;
		HUDColor = SolidHUDColor;
	}
	else
	{
		Style = ERenderStyle.STY_Translucent;
		BaseColor = (16 * Opacity + 15) * UnitColor;
		HUDColor = FavoriteHUDColor * (Opacity + 0.9);
	}
	Canvas.DrawColor = BaseColor;
	Canvas.Style = Style;
	bLowRes = ( Canvas.ClipX < 400 );
	if ( bLowRes )
		WeaponScale = 1.0;
		
	//Draw F8 notice:
	if ( !PawnOwner.PlayerReplicationInfo.bWaitingPlayer )
		{
		Canvas.bCenter = True;
		Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor * 0.1;
		Canvas.SetPos(1, 65);
		Canvas.DrawText(MenuKeyName$" = Open/close menu.", False);
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(0, 64);
		Canvas.DrawText(MenuKeyName$" = Open/close menu.", False);
		Canvas.bCenter = False;
		}
}

simulated function DrawMoney(Canvas Canvas)
{
local float X,Y;
local int i,s,ScoreLength;
local string Score;

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;
		
	X = 0;
	Y = Canvas.ClipY - 64;
	
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.SetPos(X, Y);
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.DollarIcon', 64, 64, 0, 0, 64.0, 64.0);
	X += 64;
	
	Score = string(int(Pawn(Owner).PlayerReplicationInfo.Score));
	ScoreLength = len(Score);
	
	for (i=0;i<ScoreLength;i++)
		{
		if ( left(Score,1) == "0" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 0, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "1" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 34, 64, 88, 0, 34.0, 64.0);
			X += 34;
			}
		else if ( left(Score,1) == "2" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 153, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "3" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 242, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "4" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 331, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "5" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 420, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "6" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 509, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "7" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 598, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "8" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 687, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "9" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 776, 0, 58.0, 64.0);
			X += 58;
			}
		s += 1;
		Score = right(Score, ScoreLength - s);
		}	
}


simulated function DrawLives(Canvas Canvas)
{
local float X,Y;
local int i,s,ScoreLength;
local string Score;
local GRI GRI;

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;
		
	X = 0;
	Y = Canvas.ClipY - 128;
	
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.SetPos(X, Y);
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.HealthIcon', 64, 64, 0, 0, 64.0, 64.0);
	X += 64;
	
	GRI = GRI(PlayerOwner.GameReplicationInfo);
	Score = string(GRI.Lives);
	if ( GRI.Lives <= 0 )
		bGameOver = True;
	ScoreLength = len(Score);
	
	for (i=0;i<ScoreLength;i++)
		{
		if ( left(Score,1) == "0" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 0, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "1" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 34, 64, 88, 0, 34.0, 64.0);
			X += 34;
			}
		else if ( left(Score,1) == "2" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 153, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "3" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 242, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "4" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 331, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "5" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 420, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "6" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 509, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "7" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 598, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "8" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 687, 0, 58.0, 64.0);
			X += 58;
			}
		else if ( left(Score,1) == "9" )
			{
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Numbers', 58, 64, 776, 0, 58.0, 64.0);
			X += 58;
			}
		s += 1;
		Score = right(Score, ScoreLength - s);
		}	
}

simulated function DrawRound(Canvas Canvas)
{
local float XL,YL;
local GRI GRI;

	if ( GRI(PlayerOwner.GameReplicationInfo) == None )
		return;
	
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );

	Canvas.bCenter = False;
	
	GRI = GRI(PlayerOwner.GameReplicationInfo);
	Canvas.StrLen("Round:"@GRI.Round, XL, YL);
	Canvas.SetPos(0, Canvas.ClipY - 128 - YL);
	Canvas.DrawText("Round:"@GRI.Round, False);
	
	//Track if player is victorious:
	if ( GRI.bVictorious && !bPlayVictory )
		bDrawVictory = True;
}

simulated function DrawCurrentWeapon(Canvas Canvas)
{
local float XL,YL;
local PBWeapon PBW;
local string ItemName;

	PBW = PBWeapon(PawnOwner.Weapon);
	if ( PBW != None )
		{
		if ( !PBW.IsA('Weapon_Tower') )
			{
			Canvas.DrawColor = WhiteColor; 
			Canvas.Style = ERenderStyle.STY_Normal;
			Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
			Canvas.StrLen(PBW.ItemName, XL, YL);
			Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - YL);
			Canvas.DrawText(PBW.ItemName, False);
			}
		else
			{
			if ( Weapon_Tower(PBW).TowerType == Class'Tower_Krall' )
				ItemName = "Krall Tower";
			else if ( Weapon_Tower(PBW).TowerType == Class'Tower_Slith' )
				ItemName = "Slith Tower";
			else if ( Weapon_Tower(PBW).TowerType == Class'Tower_LaserCannon' )
				ItemName = "Laser Cannon Tower";
			else if ( Weapon_Tower(PBW).TowerType == Class'Tower_Warlord' )
				ItemName = "Warlord Tower";
			else if ( Weapon_Tower(PBW).TowerType == Class'Tower_Nali' )
				ItemName = "Nali Tower";
			else if ( Weapon_Tower(PBW).TowerType == Class'Tower_RingOfFire' )
				ItemName = "Ring Of Fire Tower";
			Canvas.DrawColor = WhiteColor; 
			Canvas.Style = ERenderStyle.STY_Normal;
			Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
			Canvas.StrLen(ItemName, XL, YL);
			Canvas.SetPos(Canvas.ClipX * 0.5 - 0.5 * XL, Canvas.ClipY - YL);
			Canvas.DrawText(ItemName, False);
			}
		}
}

/* Calculate and draw rank:	*/
simulated function DrawRank(Canvas Canvas)
{
local float XL,YL,Progress,Rank,RankScore,NextRank;
local int i;

	Rank = PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).Rank;
	RankScore = PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).RankScore;
	NextRank = 1000;
	for (i=0;i<Rank;i++)
		{
		NextRank += 1000 * Rank * Rank;
		}

	Progress = RankScore / NextRank;
	if ( Progress >= 1.00 )
		{
		PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).Rank += 1;
		PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).RankScore = RankScore - NextRank;
		Progress = 1.00;
		PlayerPawn(Owner).ReceiveLocalizedMessage( class'RankUpMessage',Rank + 1,);
		}
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 128, 0);
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.RankIcon', 256, 64, 0, 0, 256.0, 64.0);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.bCenter = True;
	Canvas.DrawColor = WhiteColor * 0.25;
	Canvas.SetPos(1, 5);
	Canvas.DrawText("Rank:"@int(Rank), False);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0, 4);
	Canvas.DrawText("Rank:"@int(Rank), False);
	Canvas.bCenter = False;
	//Calculate progress and draw bar: 234x13 total, X offset: 11, Y offset: 43
	Canvas.SetPos(Canvas.ClipX * 0.5 - 128 + 11, 0 + 43);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cGreen', 234 * Progress, 13, 0, 0, 2.0, 2.0);
}

simulated function DrawHealth(Canvas Canvas)
{
local float HealthA,HealthB,AY,BY;

	HealthA = PlayerPawn(Owner).Health;
	if ( HealthA < 0 )
		HealthA = 0;
	HealthB = 100 - HealthA;
	
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.SetPos(Canvas.ClipX - 128, 0);
	if ( HealthA == 0 )
		{
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.TombStone', 128, 128, 0, 0, 256.0, 256.0);
		}
	else if ( HealthB > 0 )
		{
		BY = HealthB / 100;
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.HealthB', 128, 128 * BY, 0, 0, 256.0, 256.0 * BY);
		Canvas.SetPos(Canvas.ClipX - 128, 0 + 128 * BY);
		AY = 1.0 - BY;
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.HealthA', 128, 128 * AY, 0, 256 - (256 * AY), 256.0, 256.0 * AY);
		}
	else
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.HealthA', 128, 128, 0, 0, 256.0, 256.0);
	Canvas.Style = ERenderStyle.STY_Normal;
}

simulated function DrawLayersPopped(Canvas Canvas)
{
local float XL,YL;
local PBWeapon PBW;

	PBW = PBWeapon(PawnOwner.Weapon);
	if ( PBW != None)
		{
		Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
		Canvas.DrawColor = WhiteColor;
		
		Canvas.Style = ERenderStyle.STY_Masked;
		
		Canvas.SetPos(Canvas.ClipX - 128, Canvas.ClipY - 64);
		if ( Pawn(Owner).PlayerReplicationInfo.Score < PBW.CostPrimary )
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.LayerIcon_off', 64, 64, 0, 0, 64.0, 64.0);
			}
		else
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.LayerIcon_on', 64, 64, 0, 0, 64.0, 64.0);
			}
			
		Canvas.SetPos(Canvas.ClipX - 64, Canvas.ClipY - 64);
		
		if ( Pawn(Owner).PlayerReplicationInfo.Score < PBW.CostAlt || PBW.PopAlt == 0 )
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.LayerIcon_off', 64, 64, 0, 0, 64.0, 64.0);
			}
		else
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.LayerIcon_on', 64, 64, 0, 0, 64.0, 64.0);
			}
		
		Canvas.Style = ERenderStyle.STY_Normal;
		
		Canvas.StrLen("Primary $"$PBW.CostPrimary, XL, YL);
		Canvas.SetPos(Canvas.ClipX - 96 - 0.5 * XL, Canvas.ClipY - 64 - YL);
		Canvas.DrawText("Primary $"$PBW.CostPrimary, False);
		
		Canvas.StrLen("x"$PBW.PopPrimary, XL, YL);
		Canvas.SetPos(Canvas.ClipX - 96 - 0.5 * XL, Canvas.ClipY - 4 - YL);
		Canvas.DrawText("x"$PBW.PopPrimary, False);
		
		if ( PBW.CostAlt != 0 || PBW.IsA('Weapon_Enforcer') )
			{
			Canvas.StrLen("Alt $"$PBW.CostAlt, XL, YL);
			Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL, Canvas.ClipY - 64 - YL);
			Canvas.DrawText("Alt $"$PBW.CostAlt, False);
		
			Canvas.StrLen("x"$PBW.PopAlt, XL, YL);
			Canvas.SetPos(Canvas.ClipX - 32 - 0.5 * XL, Canvas.ClipY - 4 - YL);
			Canvas.DrawText("x"$PBW.PopAlt, False);
			}
		
		Canvas.StrLen("Clay", XL, YL);
		Canvas.SetPos(Canvas.ClipX - 16 - XL, Canvas.ClipY - 64 - 5.5*YL);
		Canvas.DrawText("Clay", False);
		
		Canvas.StrLen("Metal", XL, YL);
		Canvas.SetPos(Canvas.ClipX - 16 - XL, Canvas.ClipY - 64 - 4.5*YL);
		Canvas.DrawText("Metal", False);
		
		Canvas.StrLen("Liquid", XL, YL);
		Canvas.SetPos(Canvas.ClipX - 16 - XL, Canvas.ClipY - 64 - 3.5*YL);
		Canvas.DrawText("Liquid", False);
		
		Canvas.StrLen("Standard", XL, YL);
		Canvas.SetPos(Canvas.ClipX - 16 - XL, Canvas.ClipY - 64 - 2.5*YL);
		Canvas.DrawText("Standard", False);
		
		Canvas.Style = ERenderStyle.STY_Masked;
		
		Canvas.SetPos(Canvas.ClipX - 16, Canvas.ClipY - 64 - 5.5*YL);
		if ( PBW.bClay )
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Yes', 16, 16, 0, 0, 32.0, 32.0);
			}
		else
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.No', 16, 16, 0, 0, 32.0, 32.0);
			}
		
		Canvas.SetPos(Canvas.ClipX - 16, Canvas.ClipY - 64 - 4.5*YL);
		if ( PBW.bMetal )
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Yes', 16, 16, 0, 0, 32.0, 32.0);
			}
		else
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.No', 16, 16, 0, 0, 32.0, 32.0);
			}
		
		Canvas.SetPos(Canvas.ClipX - 16, Canvas.ClipY - 64 - 3.5*YL);
		if ( PBW.bLiquid )
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Yes', 16, 16, 0, 0, 32.0, 32.0);
			}
		else
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.No', 16, 16, 0, 0, 32.0, 32.0);
			}
			
		Canvas.SetPos(Canvas.ClipX - 16, Canvas.ClipY - 64 - 2.5*YL);
		if ( PBW.bStandard )
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Yes', 16, 16, 0, 0, 32.0, 32.0);
			}
		else
			{
			Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.No', 16, 16, 0, 0, 32.0, 32.0);
			}
		}
}

simulated function DisplayProgressMessage( canvas Canvas )
{
	local int i;
	local float XL, YL, YOffset, X, Scale;
	local GRI GRI;

	PlayerOwner.ProgressTimeOut = FMin(PlayerOwner.ProgressTimeOut, Level.TimeSeconds + 8);
	Canvas.Style = ERenderStyle.STY_Normal;	

	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	if ( UTIntro(Level.Game) != None )
		YOffset = 64 * scale + 2 * YL;
	else if ( (MOTDFadeOutTime <= 0) || (Canvas.ClipY < 300) )
		YOffset = 64 * scale + 6 * YL;
	else
		{
		YOffset = 64 * scale + 6 * YL;
		Canvas.DrawColor = WhiteColor; 
		Canvas.Style = ERenderStyle.STY_Masked;
		if ( Canvas.ClipX < 1024 )
			Scale = Canvas.ClipX / 1024;
		else
			Scale = 1;
		X = 512 * Scale;
		Canvas.SetPos(Canvas.ClipX * 0.5 - X, 10);
		Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.PB_Logo', 1024 * Scale, 128 * Scale, 0, 0, 1024.0, 128.0);
		Canvas.Style = ERenderStyle.STY_Normal;
		}
	for (i=0; i<8; i++)
	{
		Canvas.SetPos(0, YOffset);
		Canvas.DrawColor = PlayerPawn(Owner).ProgressColor[i];
		Canvas.DrawText(PlayerPawn(Owner).ProgressMessage[i], False);
		YOffset += YL + 1;
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.bCenter = False;
	HUDSetup(Canvas);	
}

function DrawTalkFace(Canvas Canvas, int i, float YPos)
{
	if ( !bHideHUD && !PawnOwner.PlayerReplicationInfo.bIsSpectator )
	{
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(FaceAreaOffset + 4*Scale, 4*Scale);
		Canvas.DrawTile(FaceTexture, YPos - 1*Scale, YPos - 1*Scale, 0, 0, FaceTexture.USize, FaceTexture.VSize);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = FaceColor;
		Canvas.SetPos(FaceAreaOffset, 0);
		Canvas.DrawTile(texture'LadrStatic.Static_a00', YPos + 7*Scale, YPos + 7*Scale, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);
		Canvas.DrawColor = WhiteColor;
	}
}

function bool DrawSpeechArea( Canvas Canvas, float XL, float YL )
{
	local float YPos, Yadj;
	local float WackNumber;
	local int paneltype;

	YPos = FMax(YL*4 + 8, 70*Scale);
	Yadj = YPos + 7*Scale;
	YPos *=2;
	MinFaceAreaOffset = -1 * Yadj;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = HUDColor * MessageFadeTime;

	Canvas.SetPos(FaceAreaOffset, 0);
	Canvas.DrawTile(texture'LadrStatic.Static_a00', Yadj, Yadj, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);

	WackNumber = 512*Scale - 64 + FaceAreaOffset; // 256*Scale - (512*Scale - (768*Scale - 64 + FaceAreaOffset));
	if ( !PlayerOwner.Player.Console.bTyping )
		paneltype = 0;
	else 
	{
		Canvas.StrLen("(>"@PlayerOwner.Player.Console.TypedStr$"_", XL, YL);
		if (XL < 768*Scale)
			paneltype = 1;
		else 
			paneltype = 2;
	}

	Canvas.SetPos(Yadj + FaceAreaOffset, 0);
	Canvas.DrawTile(FP1[paneltype], 256*Scale - FaceAreaOffset, YPos, 0, 0, FP1[paneltype].USize, FP1[paneltype].VSize);

	Yadj += 256 * Scale;
	Canvas.SetPos(Yadj, 0);
	Canvas.DrawTile(FP2[paneltype], WackNumber, YPos, 0, 0, FP2[paneltype].USize, FP2[paneltype].VSize);

	Canvas.SetPos(Yadj + WackNumber, 0);
	Canvas.DrawTile(FP3[paneltype], 64, YPos, 0, 0, FP3[paneltype].USize, FP3[paneltype].VSize);
}

//========================================
// Master HUD render function.

simulated function PostRender( canvas Canvas )
{
local float XL, YL, XPos, YPos, FadeValue;
local string Message;
local int M, i, j, k, XOverflow;
local float OldOriginX;
local GRI GRI;

	GRI = GRI(DeathMatchPlus(Level.Game).GameReplicationInfo);

	if ( Owner.IsA('Spectator') )
		Return;
	
	if ( Key == "" )
		{
		CreateKey();
		PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).Key = Key;
		SaveConfig();
		}
	else
		PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).Key = Key;
		
	
	HUDSetup(canvas);
	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bMenuOpen )
		{
		if ( !bFixedLocation )
			{
			FixedLocation = PlayerPawn(Owner).Location;
			bFixedLocation = True;
			}
		ShowMenu(Canvas);
		TrackInput(Canvas);
		//Return;
		}
	else
		bFixedLocation = False;
	
	if ( PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawVoteMenu )
		{
		DrawVoteMenu(Canvas);
		TrackInput(Canvas);
		//Return;
		}
	
	if ( bShowInfo )
		{
		DrawPBInfo(Canvas);
		return;
		}
	
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	OldOriginX = Canvas.OrgX;
	// Master message short queue control loop.
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
	bDrawFaceArea = false;
	if ( !bHideFaces && !PlayerOwner.bShowScores && !bForceScores && !bHideHUD 
			&& !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.4) )
	{
		DrawSpeechArea(Canvas, XL, YL);
		bDrawFaceArea = (FaceTexture != None) && (FaceTime > Level.TimeSeconds);
		if ( bDrawFaceArea )
		{
			if ( !bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.PlayerReplicationInfo.bIsSpectator) )
				Canvas.SetOrigin( FMax(YL*4 + 8, 70*Scale) + 7*Scale + 6 + FaceAreaOffset, Canvas.OrgY );
		}
	}

	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message != None )
		{
			j++;

			if ( bResChanged || (ShortMessageQueue[i].XL == 0) )
			{
				if ( ShortMessageQueue[i].Message.Default.bComplexString )
					Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString( 
											self,
											ShortMessageQueue[i].Switch,
											ShortMessageQueue[i].RelatedPRI,
											ShortMessageQueue[i].StringMessage), 
								   ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				else
					Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				Canvas.StrLen("TEST", XL, YL);
				ShortMessageQueue[i].numLines = 1;
				if ( ShortMessageQueue[i].YL > YL )
				{
					ShortMessageQueue[i].numLines++;
					for (k=2; k<4-i; k++)
					{
						if (ShortMessageQueue[i].YL > YL*k)
							ShortMessageQueue[i].numLines++;
					}
				}
			}

			// Keep track of the amount of lines a message overflows, to offset the next message with.
			Canvas.SetPos(6, 2 + YL * YPos);
			YPos += ShortMessageQueue[i].numLines;
			if ( YPos > 4 )
				break; 

			if ( ShortMessageQueue[i].Message.Default.bComplexString )
			{
				// Use this for string messages with multiple colors.
				ShortMessageQueue[i].Message.Static.RenderComplexMessage( 
					Canvas,
					ShortMessageQueue[i].XL,  YL,
					ShortMessageQueue[i].StringMessage,
					ShortMessageQueue[i].Switch,
					ShortMessageQueue[i].RelatedPRI,
					None,
					ShortMessageQueue[i].OptionalObject
					);				
			} 
			else
			{
				Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
				Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
		}
	}

	Canvas.DrawColor = WhiteColor;
	Canvas.SetClip(OldClipX, Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
			PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
		if ( PlayerOwner.Scoring != None )
		{ 
			PlayerOwner.Scoring.OwnerHUD = self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
				DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
			return;
		}
	}

	YPos = FMax(YL*4 + 8, 70*Scale);
	if ( bDrawFaceArea )
		DrawTalkFace( Canvas,0, YPos );
	if (j > 0) 
	{
		bDrawMessageArea = True;
		MessageFadeCount = 2;
	} 
	else 
		bDrawMessageArea = False;

	if ( !bHideCenterMessages )
	{
		// Master localized message control loop.
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message != None)
			{
				if (LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode)
				{
					Canvas.Style = ERenderStyle.STY_Translucent;
					FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
					if (FadeValue > 0.0)
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
								LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
							else // ==2
								LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
							Canvas.Font = LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
							LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
						}
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
						Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
						Canvas.DrawText( LocalMessages[i].StringMessage, False );
					}
				} 
				else 
				{
					if ( bResChanged || (LocalMessages[i].XL == 0) )
					{
						if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
							LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
						else // == 2
							LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
						LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
					}
					Canvas.Font = LocalMessages[i].StringFont;
					Canvas.Style = ERenderStyle.STY_Normal;
					Canvas.DrawColor = LocalMessages[i].DrawColor;
					Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
					Canvas.DrawText( LocalMessages[i].StringMessage, False );
				}
			}
		}
	}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None) )
	{
		Canvas.DrawColor = WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if ( !PawnOwner.Weapon.bOwnsCrossHair && !PBPRI(PawnOwner.PlayerReplicationInfo).bMenuOpen )
			DrawCrossHair(Canvas, 0,0 );
	}

	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.bCenter = true;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = CyanColor * TutIconBlink;
		Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
		Canvas.DrawText( LiveFeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
		Canvas.bCenter = false;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = Style;
	}

	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage = false;
		PlayerOwner.SetProgressTime(7);
	}
	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages )
		DisplayProgressMessage(Canvas);

	// Display MOTD
	if ( MOTDFadeOutTime > 0.0 )
		DrawMOTD(Canvas);
		 
	if( !bHideHUD )
	{
		if ( !PawnOwner.PlayerReplicationInfo.bIsSpectator )
		{
			Canvas.Style = Style;	
			if ( !PBPRI(PawnOwner.PlayerReplicationInfo).bMenuOpen )
				{
				DrawMoney(Canvas);
				DrawLives(Canvas);
				DrawRound(Canvas);
				DrawLayersPopped(Canvas);
				DrawCurrentWeapon(Canvas);
				DrawRank(Canvas);
				DrawHealth(Canvas);
				DrawBalloonHealth(Canvas);
				DrawTowerHUDInfo(Canvas);
				}
			if ( bGameOver )
				{
				DrawGameOver(Canvas);
				if ( bDrawGameOverText )
					DrawGameOverText(Canvas);
				}
			if (bDrawVictory)
				DrawVictorious(Canvas);
			
			if ( !GRI.bRoundStarted && GRI.Round < 50 && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawVoteMenu && !PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bMenuOpen )
				DrawNextRound(Canvas);
		}

		// Display Identification Info
		if ( PawnOwner == PlayerOwner )
			DrawIdentifyInfo(Canvas);

		if ( HUDMutator != None )
			HUDMutator.PostRender(Canvas);

		if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) ) 
		{
			if ( TimeMessageClass == None )
				TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300)
			  && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid = ( bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) );	
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
						TellTime(5);
					else if ( bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10 )
						TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
				}
				else if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
				{
					M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
					TellTime(5 - M);
				}
			}
		}
	}
	if ( PlayerOwner.Player.Console.bTyping )
		DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
		Canvas.DrawIcon(texture'DisconnectWarn', Scale);
	}
}

function Timer()
{
local int i, j;

	if ( bGameOver)
		{
		if ( GameOverDelay <= 0 )
			{
			if ( GameOverDelay == 0 )
				{
				bDrawGameOverText = True;
				PlayerPawn(Owner).ClientPlaySound(Sound'Announcer.LostMatch', , true);
				GameOverDelay -= 1;
				}
			}
		else
			{
			GameOverDelay -= 1;
			}
		}
		
	if (!bDrawMessageArea)
	{
		if (MessageFadeCount > 0)
			MessageFadeCount--;
	}

	// Age the short message queue.
	for (i=0; i<4; i++)
	{
		// Purge expired messages.
		if ( (ShortMessageQueue[i].Message != None) && (Level.TimeSeconds >= ShortMessageQueue[i].EndOfLife) )
			ClearMessage(ShortMessageQueue[i]);
	}

	// Clean empty slots.
	for (i=0; i<3; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			for (j=i; j<4; j++)
			{
				if ( ShortMessageQueue[j].Message != None )
				{
					CopyMessage(ShortMessageQueue[i],ShortMessageQueue[j]);
					ClearMessage(ShortMessageQueue[j]);
					break;
				}
			}
		}
	}

	// Age all localized messages.
	for (i=0; i<10; i++)
	{
		// Purge expired messages.
		if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
			ClearMessage(LocalMessages[i]);
	}

	// Clean empty slots.
	for (i=0; i<9; i++)
	{
		if ( LocalMessages[i].Message == None )
		{
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);
			ClearMessage(LocalMessages[i+1]);
		}
	}

	if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None)
		|| (PawnOwner.PlayerReplicationInfo == None) )
		return;

	// Update the rank and spread.
	UpdateRankAndSpread();
	
	//Countdown on victory logo:
	if ( bDrawVictory && bPlayVictory )
		{
		VictoryDrawTime--;
		if ( VictoryDrawTime <= 0 )
			{
			bDrawVictory = False;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bMenuOpen = True;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawVoteMenu = True;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawWeaponsMenu = False;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawTowerMenu = False;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawUpgradeMenu = False;
			PBPRI(PlayerPawn(Owner).PlayerReplicationInfo).bDrawMusicMenu = False;
			}
		}
}

function UpdateRankAndSpread()
{
	local PlayerReplicationInfo PRI;
	local int HighScore;
	local int i, j;

	PlayerCount = 0;
	HighScore = -100;
	bTiedScore = False;
	Rank = 1;
	for (i=0; i<32; i++)
	{
		PRI = PlayerOwner.GameReplicationInfo.PRIArray[i];
		if ( (PRI != None) && (!PRI.bIsSpectator || PRI.bWaitingPlayer) )
		{
			PlayerCount++;
			if (PRI != PawnOwner.PlayerReplicationInfo)
			{
				if (PRI.Score > PawnOwner.PlayerReplicationInfo.Score)
					Rank += 1;
				else if (PRI.Score == PawnOwner.PlayerReplicationInfo.Score)
				{
					bTiedScore = True;
					if (PRI.Deaths < PawnOwner.PlayerReplicationInfo.Deaths)
						Rank += 1;
					else if (PRI.Deaths == PawnOwner.PlayerReplicationInfo.Deaths)
						if (PRI.PlayerID < PawnOwner.PlayerReplicationInfo.PlayerID)
							Rank += 1;
				}
				if (PRI.Score > HighScore)
					HighScore = PRI.Score;
			}
		}
	}
	Lead = int(PawnOwner.PlayerReplicationInfo.Score) - HighScore;
}

simulated function TellTime(int num)
{
	PlayerOwner.ReceiveLocalizedMessage( TimeMessageClass, Num );
}

simulated function Tick(float DeltaTime)
{
	local int i;

	Super.Tick(DeltaTime);

	CycleFadeColor();
	
	IdentifyFadeTime = FMax(0.0, IdentifyFadeTime - DeltaTime);
	MOTDFadeOutTime = FMax(0.0, MOTDFadeOutTime - DeltaTime * 55);
	
	TutIconBlink += DeltaTime;
	if (TutIconBlink >= 0.5)
		TutIconBlink = 0.0;

	if ( bDrawFaceArea )
	{
		if ( FaceAreaOffset < 0 )
			FaceAreaOffset += DeltaTime * 600;
		if ( FaceAreaOffset > 0 )
			FaceAreaOffset = 0.0;
	} 
	else if ( FaceAreaOffset > MinFaceAreaOffset )
		FaceAreaOffset = FMax(FaceAreaOffset - DeltaTime * 600, MinFaceAreaOffset );

	if ( bDrawMessageArea )
	{
		if ( MessageFadeTime < 1.0 )
		{
			MessageFadeTime += DeltaTime * 8;
			if (MessageFadeTime > 1.0)
				MessageFadeTime = 1.0;
		}
	} 
	else if ( (MessageFadeTime > 0.0) && (MessageFadeCount == 0) )
	{
		MessageFadeTime -= DeltaTime * 2;
		if (MessageFadeTime < 0.0)
			MessageFadeTime = 0.0;
	}
	WeaponNameFade -= DeltaTime;
}

simulated function DrawMOTD(Canvas Canvas)
{
}

simulated function DrawCrossHair( canvas Canvas, int X, int Y)
{
	local float XScale, PickDiff;
	local float XLength;
	local texture T;

 	if (Crosshair>=CrosshairCount) Return;
	if ( Canvas.ClipX < 512 )
		XScale = 0.5;
	else
		XScale = FMax(1, int(0.1 + Canvas.ClipX/640.0));
	PickDiff = Level.TimeSeconds - PickupTime;
	if ( PickDiff < 0.4 )
	{
		if ( PickDiff < 0.2 )
			XScale *= (1 + 5 * PickDiff);
		else
			XScale *= (3 - 5 * PickDiff);
	}
	XLength = XScale * 64.0;

	Canvas.bNoSmooth = False;
	if ( PlayerOwner.Handedness == -1 )
		Canvas.SetPos(0.503 * (Canvas.ClipX - XLength), 0.504 * (Canvas.ClipY - XLength));
	else if ( PlayerOwner.Handedness == 1 )
		Canvas.SetPos(0.497 * (Canvas.ClipX - XLength), 0.496 * (Canvas.ClipY - XLength));
	else
		Canvas.SetPos(0.5 * (Canvas.ClipX - XLength), 0.5 * (Canvas.ClipY - XLength));
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = 15 * CrosshairColor;

	T = CrossHairTextures[Crosshair];
	if( T == None )
		T = LoadCrosshair(Crosshair);

	Canvas.DrawTile(T, XLength, XLength, 0, 0, 64, 64);
	Canvas.bNoSmooth = True;
	Canvas.Style = Style;
}

simulated function DrawTypingPrompt( canvas Canvas, console Console )
{
	local string TypingPrompt;
	local float XL, YL, YPos, XOffset;
	local float MyOldClipX, OldClipY, OldOrgX, OldOrgY;

	MyOldClipX = Canvas.ClipX;
	OldClipY = Canvas.ClipY;
	OldOrgX = Canvas.OrgX;
	OldOrgY = Canvas.OrgY;

	Canvas.DrawColor = GreenColor;
	TypingPrompt = "(>"@Console.TypedStr$"_";
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen( "TEST", XL, YL );
	YPos = YL*4 + 8;
	if (PawnOwner.PlayerReplicationInfo.bIsSpectator || bHideHUD || bHideFaces)
		XOffset = 0;
	else
		XOffset = FMax(0,FaceAreaOffset + 15*Scale + YPos);
	Canvas.SetOrigin(XOffset, FMax(0,YPos + 7*Scale));
	Canvas.SetClip( 760*Scale, Canvas.ClipY );
	Canvas.SetPos( 0, 0 );
	Canvas.DrawText( TypingPrompt, false );
	Canvas.SetOrigin( OldOrgX, OldOrgY );
	Canvas.SetClip( MyOldClipX, OldClipY );
}

// Entry point for string messages.
simulated function Message( PlayerReplicationInfo PRI, coerce string Msg, name MsgType )
{
	local int i;
	local Class<LocalMessage> MessageClass;

	switch (MsgType)
	{
		case 'Say':
		case 'TeamSay':
			MessageClass = class'SayMessagePlus';
			break;
		case 'CriticalEvent':
			MessageClass = class'CriticalStringPlus';
			LocalizedMessage( MessageClass, 0, None, None, None, Msg );
			return;
		case 'DeathMessage':
			MessageClass = class'RedSayMessagePlus';
			break;
		case 'Pickup':
			PickupTime = Level.TimeSeconds;
		default:
			MessageClass = class'StringMessagePlus';
			break;
	}

	if ( ClassIsChildOf(MessageClass, class'SayMessagePlus') || 
				     ClassIsChildOf(MessageClass, class'TeamSayMessagePlus') )
	{
		FaceTexture = PRI.TalkTexture;
		if ( FaceTexture != None )
			FaceTime = Level.TimeSeconds + 3;
		if ( Msg == "" )
			return;
	} 
	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			// Add the message here.
			ShortMessageQueue[i].Message = MessageClass;
			ShortMessageQueue[i].Switch = 0;
			ShortMessageQueue[i].RelatedPRI = PRI;
			ShortMessageQueue[i].OptionalObject = None;
			ShortMessageQueue[i].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
			if ( MessageClass.Default.bComplexString )
				ShortMessageQueue[i].StringMessage = Msg;
			else
				ShortMessageQueue[i].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
			return;
		}
	}

	// No empty slots.  Force a message out.
	for (i=0; i<3; i++)
		CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

	ShortMessageQueue[3].Message = MessageClass;
	ShortMessageQueue[3].Switch = 0;
	ShortMessageQueue[3].RelatedPRI = PRI;
	ShortMessageQueue[3].OptionalObject = None;
	ShortMessageQueue[3].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
	if ( MessageClass.Default.bComplexString )
		ShortMessageQueue[3].StringMessage = Msg;
	else
		ShortMessageQueue[3].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
}

simulated function bool DisplayMessages( canvas Canvas )
{
	return true;
}

simulated function float DrawNextMessagePart(Canvas Canvas, string MString, float XOffset, int YPos)
{
	local float XL, YL;

	Canvas.SetPos(4 + XOffset, YPos);
	Canvas.StrLen( MString, XL, YL );
	Canvas.DrawText( MString, false );
	return (XOffset + XL);
}

//================================================================================
// Identify Info

simulated function bool TraceIdentify(canvas Canvas)
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	StartTrace = PawnOwner.Location;
	StartTrace.Z += PawnOwner.BaseEyeHeight;
	EndTrace = StartTrace + vector(PawnOwner.ViewRotation) * 1000.0;
	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if ( Pawn(Other) != None )
	{
		if ( Pawn(Other).bIsPlayer && !Other.bHidden )
		{
			IdentifyTarget = Pawn(Other).PlayerReplicationInfo;
			IdentifyFadeTime = 3.0;
		}
	}
	else if ( (Other != None) && SpecialIdentify(Canvas, Other) )
		return false;

	if ( (IdentifyFadeTime == 0.0) || (IdentifyTarget == None) || IdentifyTarget.bFeigningDeath )
		return false;

	return true;
}

simulated function bool SpecialIdentify(Canvas Canvas, Actor Other )
{
	return false;
}

simulated function SetIDColor( Canvas Canvas, int type )
{
	Canvas.DrawColor = GreenColor;
	if ( type == 0 )
		Canvas.DrawColor.G = 160 * (IdentifyFadeTime / 3.0);
	else
		Canvas.DrawColor.G = 255 * (IdentifyFadeTime / 3.0);
}

simulated function DrawTwoColorID( canvas Canvas, string TitleString, string ValueString, int YStart )
{
	local float XL, YL, XOffset, X1;

	Canvas.Style = Style;
	Canvas.StrLen(TitleString$": ", XL, YL);
	X1 = XL;
	Canvas.StrLen(ValueString, XL, YL);
	XOffset = Canvas.ClipX/2 - (X1+XL)/2;
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,0);
	XOffset += X1;
	Canvas.DrawText(TitleString);
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,1);
	Canvas.DrawText(ValueString);
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
}
	
simulated function bool DrawIdentifyInfo(canvas Canvas)
{
	if ( !TraceIdentify(Canvas))
		return false;

	if( IdentifyTarget.PlayerName != "" )
	{
		Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
		DrawTwoColorID(Canvas,IdentifyName, IdentifyTarget.PlayerName, Canvas.ClipY - 256 * Scale);
	}
	return true;
}

//=====================================================================
// Deal with a localized message.

simulated function LocalizedMessage( class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional String CriticalString )
{
	local int i;

	if ( ClassIsChildOf( Message, class'PickupMessagePlus' ) )
		PickupTime = Level.TimeSeconds;

	if ( !Message.Default.bIsSpecial )
	{
		if ( ClassIsChildOf(Message, class'SayMessagePlus') || 
						 ClassIsChildOf(Message, class'TeamSayMessagePlus') )
		{
			FaceTexture = RelatedPRI_1.TalkTexture;
			if ( FaceTexture != None )
				FaceTime = Level.TimeSeconds + 3;
		} 
		// Find an empty slot.
		for (i=0; i<4; i++)
		{
			if ( ShortMessageQueue[i].Message == None )
			{
				ShortMessageQueue[i].Message = Message;
				ShortMessageQueue[i].Switch = Switch;
				ShortMessageQueue[i].RelatedPRI = RelatedPRI_1;
				ShortMessageQueue[i].OptionalObject = OptionalObject;
				ShortMessageQueue[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				if ( Message.Default.bComplexString )
					ShortMessageQueue[i].StringMessage = CriticalString;
				else
					ShortMessageQueue[i].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
				return;
			}

		}
		// No empty slots.  Force a message out.
		for (i=0; i<3; i++)
			CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

		ShortMessageQueue[3].Message = Message;
		ShortMessageQueue[3].Switch = Switch;
		ShortMessageQueue[3].RelatedPRI = RelatedPRI_1;
		ShortMessageQueue[3].OptionalObject = OptionalObject;
		ShortMessageQueue[3].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		if ( Message.Default.bComplexString )
			ShortMessageQueue[3].StringMessage = CriticalString;
		else
			ShortMessageQueue[3].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		return;
	} 
	else 
	{
		if ( CriticalString == "" )
			CriticalString = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		if ( Message.Default.bIsUnique )
		{
			for (i=0; i<10; i++)
			{
				if (LocalMessages[i].Message != None)
				{
					if ((LocalMessages[i].Message == Message) 
						|| (LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, 24, 640) 
								== Message.Static.GetOffset(Switch, 24, 640)) ) 
					{
						LocalMessages[i].Message = Message;
						LocalMessages[i].Switch = Switch;
						LocalMessages[i].RelatedPRI = RelatedPRI_1;
						LocalMessages[i].OptionalObject = OptionalObject;
						LocalMessages[i].LifeTime = Message.Default.Lifetime;
						LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
						LocalMessages[i].StringMessage = CriticalString;
						LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
						LocalMessages[i].XL = 0;
						return;
					}
				}
			}
		}
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message == None)
			{
				LocalMessages[i].Message = Message;
				LocalMessages[i].Switch = Switch;
				LocalMessages[i].RelatedPRI = RelatedPRI_1;
				LocalMessages[i].OptionalObject = OptionalObject;
				LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				LocalMessages[i].StringMessage = CriticalString;
				LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
				LocalMessages[i].LifeTime = Message.Default.Lifetime;
				LocalMessages[i].XL = 0;
				return;
			}
		}

		// No empty slots.  Force a message out.
		for (i=0; i<9; i++)
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);

		LocalMessages[9].Message = Message;
		LocalMessages[9].Switch = Switch;
		LocalMessages[9].RelatedPRI = RelatedPRI_1;
		LocalMessages[9].OptionalObject = OptionalObject;
		LocalMessages[9].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		LocalMessages[9].StringMessage = CriticalString;
		LocalMessages[9].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
		LocalMessages[9].LifeTime = Message.Default.Lifetime;
		LocalMessages[9].XL = 0;
		return;
	}
}


simulated function DrawBalloonHealth(Canvas Canvas)
{
local Balloon B;
local vector X, Y, Z, CamLoc, TargetDir, Dir, XY;
local rotator CamRot;
local Actor Camera;
local float BaseBeaconScale, BeaconScale, Dist, DistScale, TanFOVx, TanFOVy, TanX, TanY, dx, dy, FontY, HealthBarScale, Ypos;
//local string TempText;

	Canvas.Style = ERenderStyle.STY_Masked;

	Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
	
	Canvas.SetPos(0, 0);
	Canvas.TextSize("X", dx, FontY);
	BaseBeaconScale = 1.5 * FontY / Texture'PopBalloonsTextures.HUD.RankIcon'.VSize;
	
    Canvas.ViewPort.Actor.PlayerCalcView(Camera, CamLoc, CamRot);

	TanFOVx = Tan(Canvas.ViewPort.Actor.FOVAngle / 114.591559); // 360/Pi = 114.5915590...
	TanFOVy = (Canvas.ClipY / Canvas.ClipX) * TanFOVx;
	GetAxes(CamRot, X, Y, Z);
	
	Canvas.bNoSmooth = False;
	Canvas.Style = ERenderStyle.STY_Masked;
	foreach AllActors(class'Balloon', B)
        {
		if ( B != none && B != Camera && B.Health > 0 && !B.bHidden )
		    {
            TargetDir = B.Location - CamLoc;
			Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);		
			// Draw balloon health bar if player is close to the balloon:
			if (Dist < 300)
                {
				TargetDir = Normal(TargetDir + vect(0,0,1) * B.CollisionHeight);
				DistScale = FMin(100.0 * B.CollisionRadius / Dist, 1.0);
				BeaconScale = BaseBeaconScale * DistScale;
				Dir = X * (X dot TargetDir);
				XY = TargetDir - Dir;				
				dx = Canvas.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
				dy = Canvas.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));
				HealthBarScale = float(B.Health) / float(B.Default.Health);
				//TempText = B.Default.Health $ "," $ B.Health;
				Ypos = dy - 1.75 * FontY + 128 + (300 - Dist);
				Canvas.SetPos(dx + 0.6 * BeaconScale * Texture'PopBalloonsTextures.HUD.HealthBar'.USize - 48, Ypos);
				Canvas.DrawColor = WhiteColor;
				Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.HealthBar', 64 , 8, 0, 0, 64, 8);
				Canvas.SetPos(dx + 0.6 * BeaconScale * Texture'PopBalloonsTextures.HUD.HealthBar'.USize - 46, Ypos + 2);
				Canvas.DrawTile(Texture'PopBalloonsTextures.Colors.cGreen', 60 * HealthBarScale , 4, 0, 0, 2, 2);
				//Canvas.DrawTextClipped(TempText, False);
				}
			}
		}
}


simulated function DrawTowerHUDInfo(Canvas Canvas)
{
local Tower T;
local vector X, Y, Z, CamLoc, TargetDir, Dir, XY;
local rotator CamRot;
local Actor Camera;
local float BaseBeaconScale, BeaconScale, Dist, DistScale, TanFOVx, TanFOVy, TanX, TanY, dx, dy, FontY, HealthBarScale, Ypos, XL, YL;

	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.Font = MyFonts.GetSmallestFont( Canvas.ClipX );
	
	Canvas.SetPos(0, 0);
	Canvas.TextSize("X", dx, FontY);
	
	BaseBeaconScale = 1.5 * FontY / Texture'PopBalloonsTextures.HUD.RankIcon'.VSize;
	
    Canvas.ViewPort.Actor.PlayerCalcView(Camera, CamLoc, CamRot);

	TanFOVx = Tan(Canvas.ViewPort.Actor.FOVAngle / 114.591559); // 360/Pi = 114.5915590...
	TanFOVy = (Canvas.ClipY / Canvas.ClipX) * TanFOVx;
	GetAxes(CamRot, X, Y, Z);
	
	Canvas.bNoSmooth = False;
	Canvas.Style = ERenderStyle.STY_Masked;
	foreach AllActors(class'Tower', T)
        {
		if ( T != none && T != Camera && !T.bHidden )
		    {
            TargetDir = T.Location - CamLoc;
			Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);		
			if (Dist < 200)
                {
				TargetDir = Normal(TargetDir + vect(0,0,1) * T.CollisionHeight);
				DistScale = FMin(100.0 * T.CollisionRadius / Dist, 1.0);
				BeaconScale = BaseBeaconScale * DistScale;
				Dir = X * (X dot TargetDir);
				XY = TargetDir - Dir;				
				dx = Canvas.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
				dy = Canvas.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));
				Ypos = dy - 1.75 * FontY + 128 + (300 - Dist);
				Canvas.SetPos(dx + 0.6 * BeaconScale, Ypos);
				Canvas.DrawColor = WhiteColor;
				Canvas.DrawTextClipped(T.TowerName$"("$T.TowerNum$")", False);
				Canvas.StrLen(T.TowerName$"("$T.TowerNum$")", XL, YL);
				Canvas.SetPos(dx + 0.6 * BeaconScale, Ypos + YL);
				Canvas.DrawColor = RedColor;
				Canvas.DrawTextClipped("(Sell value: $"$T.TowerSellValue$")", False);
				}
			}
		}
}

simulated function DrawGameOver(Canvas Canvas)
{
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0,0);
	Canvas.DrawTile(Texture'PopBalloonsTextures.Misc.BorkenGlass', Canvas.ClipX, Canvas.ClipY, 0, 0, 512.0, 411.0);
	if ( !bGameOverSndPlayed)
		{
		PlayerPawn(Owner).ClientPlaySound(Sound'UnrealShare.General.BreakGlass', , true);
		bGameOverSndPlayed = True;
		}
}

simulated function DrawGameOverText(Canvas Canvas)
{
local float Size, Scale;

	Size = Canvas.ClipX - 20;
	Scale = Size / 680;
	
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(10,15);
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.LostMatch', Size, 64 * Scale, 0, 0, 680.0, 64.0);
}

simulated function DrawVictorious(Canvas Canvas)
{
local float Size, Scale;

	Size = Canvas.ClipX;
	Scale = Size / 1024;
	
	Canvas.Style = ERenderStyle.STY_Masked;
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0,Canvas.ClipY * 0.5 - 256 * Scale);
	Canvas.DrawTile(Texture'PopBalloonsTextures.HUD.Congratulations', Size, 512 * Scale, 0, 0, 1024.0, 512.0);
	
	if ( !bPlayVictory )
		{
		bPlayVictory = True;
		PlayerPawn(Owner).ClientPlaySound(Sound'Announcer.Winner', , true);
		}
}

simulated function DrawNextRound(Canvas Canvas)
{
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor * 0.1;
	Canvas.SetPos(1,Canvas.ClipY * 0.75 + 1);
	Canvas.DrawText("Press ENTER to begin next round.", False);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(0,Canvas.ClipY * 0.75);
	Canvas.DrawText("Press ENTER to begin next round.", False);
	Canvas.bCenter = False;
}

defaultproperties
{
	ShowWeapon=0
	PBWeapon(0)=Texture'PopBalloonsTextures.Weapons.Icon_Enforcer'
	WeaponString1(0)="Dart Gun"
	WeaponString2(0)=""
	WeaponString3(0)="Pops: Standard & Liquid balloons."
	DescriptionString1(0)=""
	DescriptionString2(0)="Your base weapon."
	PriLayersPopped(0)="1"
	AltLayersPopped(0)="1"
	WeaponPrice(0)=0
	UnlockRank(0)=1
	PBWeapon(1)=Texture'PopBalloonsTextures.Weapons.Icon_BioRifle'
	WeaponString1(1)="Glue Gun"
	WeaponString2(1)="Costs: Primary/Alt fire - $2/$2"
	WeaponString3(1)="Pops: Standard, Metal & Clay balloons."
	DescriptionString1(1)=""
	DescriptionString2(1)="The glue will slowly pop the balloons."
	PriLayersPopped(1)="2"
	AltLayersPopped(1)="2 to 20"
	WeaponPrice(1)=1500
	UnlockRank(1)=5
	PBWeapon(2)=Texture'PopBalloonsTextures.Weapons.Icon_ShockRifle'
	WeaponString1(2)="Shock Rifle"
	WeaponString2(2)="Costs: Primary/Alt fire - $3/$3"
	WeaponString3(2)="Pops: All balloons."
	DescriptionString1(2)=""
	DescriptionString2(2)=""
	PriLayersPopped(2)="3"
	AltLayersPopped(2)="8/25"
	WeaponPrice(2)=2500
	UnlockRank(2)=8
	PBWeapon(3)=Texture'PopBalloonsTextures.Weapons.Icon_PulseGun'
	WeaponString1(3)="Pulse Gun"
	WeaponString2(3)="Costs: Primary/Alt fire - $2/$2"
	WeaponString3(3)="Pops: Standard & Liquid."
	DescriptionString1(3)=""
	DescriptionString2(3)=""
	PriLayersPopped(3)="3"
	AltLayersPopped(3)="3"
	WeaponPrice(3)=2500
	UnlockRank(3)=8
	PBWeapon(4)=Texture'PopBalloonsTextures.Weapons.Icon_RazorJack'
	WeaponString1(4)="Razor Jack"
	WeaponString2(4)="Costs: Primary/Alt fire - $3/$3"
	WeaponString3(4)="Pops: Standard, Clay & Liquid."
	DescriptionString1(4)=""
	DescriptionString2(4)=""
	PriLayersPopped(4)="4"
	AltLayersPopped(4)="6"
	WeaponPrice(4)=2500
	UnlockRank(4)=10
	PBWeapon(5)=Texture'PopBalloonsTextures.Weapons.Icon_FlakCannon'
	WeaponString1(5)="Flak Cannon"
	WeaponString2(5)="Costs: Primary/Alt fire - $5/$5"
	WeaponString3(5)="Pops: All balloons."
	DescriptionString1(5)=""
	DescriptionString2(5)=""
	PriLayersPopped(5)="4 per chunk"
	AltLayersPopped(5)="15"
	WeaponPrice(5)=5000
	UnlockRank(5)=12
	PBWeapon(6)=Texture'PopBalloonsTextures.Weapons.Icon_Eightball'
	WeaponString1(6)="Rocket Launcher"
	WeaponString2(6)="Costs: Primary/Alt fire - $8/$8"
	WeaponString3(6)="Pops: Standard, Metal & Clay."
	DescriptionString1(6)=""
	DescriptionString2(6)=""
	PriLayersPopped(6)="10"
	AltLayersPopped(6)="12"
	WeaponPrice(6)=4500
	UnlockRank(6)=12
	PBWeapon(7)=Texture'PopBalloonsTextures.Weapons.Icon_SniperRifle'
	WeaponString1(7)="Sniper Rifle"
	WeaponString2(7)="Costs: Primary/Zoom - $10/$0"
	WeaponString3(7)="Pops: Standard, Clay & Liquid."
	DescriptionString1(7)=""
	DescriptionString2(7)=""
	PriLayersPopped(7)="10"
	AltLayersPopped(7)="N/A"
	WeaponPrice(7)=5000
	UnlockRank(7)=15
	PBWeapon(8)=Texture'PopBalloonsTextures.Weapons.Icon_MiniGun'
	WeaponString1(8)="Railgun"
	WeaponString2(8)="Costs: Primary/Alt fire - $3/$3"
	WeaponString3(8)="Pops: Standard & Liquid."
	DescriptionString1(8)=""
	DescriptionString2(8)=""
	PriLayersPopped(8)="2"
	AltLayersPopped(8)="2"
	WeaponPrice(8)=8000
	UnlockRank(8)=20
	PBWeapon(9)=Texture'PopBalloonsTextures.Weapons.Icon_Uzi'
	WeaponString1(9)="UZI"
	WeaponString2(9)="Costs: Primary/Alt fire - $2/$2"
	WeaponString3(9)="Pops: Standard & Liquid."
	DescriptionString1(9)=""
	DescriptionString2(9)=""
	PriLayersPopped(9)="2"
	AltLayersPopped(9)="2"
	WeaponPrice(9)=10000
	UnlockRank(9)=20
	PBWeapon(10)=Texture'PopBalloonsTextures.Weapons.Icon_ColdBreeze'
	WeaponString1(10)="Cold Breeze"
	WeaponString2(10)="Costs: Primary/Alt fire - $10/$10"
	WeaponString3(10)="Freezes: All but zeppelin class."
	DescriptionString1(10)="Frozen ballons moves slower."
	DescriptionString2(10)="The ice will slowly pop the balloon."
	PriLayersPopped(10)="2"
	AltLayersPopped(10)="2"
	WeaponPrice(10)=6000
	UnlockRank(10)=15
	ShowTower=0
	TowerName(0)="Krall Tower"
	TowerString1(0)="A weak but steady defense."
	TowerString2(0)="Fires electric bolts towards all balloon types."
	TowerPrice(0)=1000
	TowerName(1)="Slith Tower"
	TowerString1(1)="A weak but steady defense."
	TowerString2(1)="Spits its deadly poison towards all balloon types."
	TowerPrice(1)=1200
	TowerName(2)="Laser Cannon Tower"
	TowerString1(2)="A weak but steady defense."
	TowerString2(2)="Shoots laser beams towards all balloon types."
	TowerPrice(2)=1000
	TowerName(3)="Warlord Tower"
	TowerString1(3)="A good defense against big strong balloons."
	TowerString2(3)="Shoots rockets against all balloon types."
	TowerPrice(3)=5000
	TowerName(4)="Nali Tower"
	TowerString1(4)="A peaceful but helpful tower."
	TowerString2(4)="Uses his magic to slow target."
	TowerPrice(4)=2000
	TowerName(5)="Ring Of Fire Tower"
	TowerString1(5)="A powerful high damage tower."
	TowerString2(5)="Fires rings of flameballs."
	TowerPrice(5)=4000
     VersionMessage="Version"
     PlayerCountString="Ideal Player Load:"
     MapTitleString="in"
     AuthorString="by"
     MapTitleString2="Map:"
     AuthorString2="Author:"
     RankString="Rank:"
     SpreadString="Spread:"
     CrosshairCount=9
     CrossHairs(0)="Botpack.CHair1"
     CrossHairs(1)="Botpack.CHair2"
     CrossHairs(2)="Botpack.CHair3"
     CrossHairs(3)="Botpack.CHair4"
     CrossHairs(4)="Botpack.CHair5"
     CrossHairs(5)="Botpack.CHair6"
     CrossHairs(6)="Botpack.CHair7"
     CrossHairs(7)="Botpack.CHair8"
     CrossHairs(8)="Botpack.CHair9"
     FP1(0)=Texture'Botpack.FacePanel.FacePanel1'
     FP1(1)=Texture'Botpack.FacePanel.FacePanel1b'
     FP1(2)=Texture'Botpack.FacePanel.FacePanel1a'
     FP2(0)=Texture'Botpack.FacePanel.FacePanel2'
     FP2(1)=Texture'Botpack.FacePanel.FacePanel2b'
     FP2(2)=Texture'Botpack.FacePanel.FacePanel2a'
     FP3(0)=Texture'Botpack.FacePanel.FacePanel3'
     FP3(1)=Texture'Botpack.FacePanel.FacePanel3b'
     FP3(2)=Texture'Botpack.FacePanel.FacePanel3a'
     bStartUpMessage=False
     bUseTeamColor=True
     Opacity=15
     HUDScale=1.000000
     StatusScale=1.000000
     WeaponScale=0.800000
     FavoriteHUDColor=(B=16)
     CrosshairColor=(G=16)
     Style=3
     WhiteColor=(R=255,G=255,B=255)
     RedColor=(R=255)
     GreenColor=(G=255)
     CyanColor=(G=255,B=255)
     UnitColor=(R=1,G=1,B=1)
     BlueColor=(B=255)
     GoldColor=(R=255,G=255)
     PurpleColor=(R=255,B=255)
     TurqColor=(G=128,B=255)
     GrayColor=(R=200,G=200,B=200)
     FaceColor=(R=50,G=50,B=50)
     IdentifyName="Name:"
     IdentifyHealth="Health:"
     IdentifyCallsign="Callsign:"
     LiveFeed="Live Feed from "
     ScoreTime=-10000000.000000
     ServerInfoClass=Class'Botpack.ServerInfo'
     FontInfoClass="Botpack.FontInfo"
     HUDConfigWindowType="UTMenu.UTChallengeHUDConfig"
	 ShowUpgrade=6
	 GameOverDelay=2
	Songs(0)=Music'Botmca9.Botmca9'
	Titles(0)="UT99 - Botmechanic 9"
	Songs(1)=Music'Botpck10.Botpck10'
	Titles(1)="UT99 - Botpack 10"
	Songs(2)=Music'Cannon.Cannon'
	Titles(2)="UT99 - Cannon"
	Songs(3)=Music'Colossus.Colossus'
	Titles(3)="UT99 - Colossus"
	Songs(4)=Music'Course.Course'
	Titles(4)="UT99 - Course"
	Songs(5)=Music'Credits.Trophy'
	Titles(5)="UT99 - Credits"
	Songs(6)=Music'Ending.Ending'
	Titles(6)="UT99 - Ending"
	Songs(7)=Music'Enigma.Enigma'
	Titles(7)="UT99 - Enigma"
	Songs(8)=Music'firebr.Firebr'
	Titles(8)="UT99 - Firebr"
	Songs(9)=Music'Foregone.Foregone'
	Titles(9)="UT99 - Foregone"
	Songs(10)=Music'Godown.Godown'
	Titles(10)="UT99 - Go Down"
	Songs(11)=Music'Lock.Lock'
	Titles(11)="UT99 - Lock"
	Songs(12)=Music'Mech8.Mech8'
	Titles(12)="UT99 - Mech 8"
	Songs(13)=Music'Mission.Mission'
	Titles(13)="UT99 - Mission"
	Songs(14)=Music'Nether.Nether'
	Titles(14)="UT99 - Nether"
	Songs(15)=Music'Organic.Organic'
	Titles(15)="UT99 - Organic"
	Songs(16)=Music'Phantom.Phantom'
	Titles(16)="UT99 - Phantom"
	Songs(17)=Music'Razor-ub.Razor-ub'
	Titles(17)="UT99 - Razor-ub"
	Songs(18)=Music'Run.Run'
	Titles(18)="UT99 - Run"
	Songs(19)=Music'SaveMe.SaveMe'
	Titles(19)="UT99 - Save Me"
	Songs(20)=Music'Savemeg.Savemeg'
	Titles(20)="UT99 - Save Me 2"
	Songs(21)=Music'Seeker.Seeker'
	Titles(21)="UT99 - Seeker"
	Songs(22)=Music'Seeker2.Seeker2'
	Titles(22)="UT99 - Seeker 2"
	Songs(23)=Music'Skyward.Skyward'
	Titles(23)="UT99 - Skyward"
	Songs(24)=Music'Strider.Strider'
	Titles(24)="UT99 - Strider"
	Songs(25)=Music'Suprfist.Suprfist'
	Titles(25)="UT99 - Superfist"
	Songs(26)=Music'UnWorld2.unworld2'
	Titles(26)="UT99 - Unreal World 2"
	Songs(27)=Music'utmenu23.utmenu23'
	Titles(27)="UT99 - UT Menu"
	Songs(28)=Music'Uttitle.Uttitle'
	Titles(28)="UT99 - UT Title"
	Songs(29)=Music'Wheels.Wheels'
	Titles(29)="UT99 - Wheels"
	Songs(30)=Music'Level.Song'
	Titles(30)="Map Default Music"
}
